% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.scanonevar.R
\name{plot.scanonevar}
\alias{plot.scanonevar}
\title{plot.scanonevar}
\usage{
\method{plot}{scanonevar}(x, y = NULL, chrs = unique(x$chr), units.to.plot,
  col = c("black", "blue", "red", "forestgreen"), bandcol = "lightgray",
  legends = if (is.null(y)) {     c("DGLM-joint", "DGLM-mean", "DGLM-var") }
  else {     c("DGLM-joint", "DGLM-mean", "DGLM-var", "LM") },
  legend.pos = "top", legend.ncol = 2, legend.cex = 1, gap = 25,
  incl.markers = TRUE, title = attr(x, "pheno"), title.cex = 1.5,
  ylim = c(0, 1.05 * max(coords.y.locus, na.rm = TRUE)),
  show.equations = (length(chrs) != 1), alpha.side = "left",
  line.width = 1, vertical.bar = NA, ...)
}
\arguments{
\item{x}{the \code{scanonevar} object to be plotted}

\item{y}{Optionally, a \code{scanone} object to be plotting for comparison to the \code{scanonevar} object.}

\item{chrs}{Optionally, the subset of the chromosomes to plot}

\item{units.to.plot}{Optionally, whether to plot 'lods' or 'emp.ps'.}

\item{col}{Optionally, a vector specifying the colors of the scan lines.  Defaults to \code{c("black", "blue", "red", "darkgreen")}.}

\item{bandcol}{Optionally, a background color for the even-index chromosomes in this scan.}

\item{legends}{Optionally, the name to put for each scan in the legend.  Defaults to \code{c('mean or var', 'mean', 'var', 'scanone for comparison')}.}

\item{legend.pos}{Optionally, the corner/edge where the legend should be drawn.  Defaults to \code{'top'}.}

\item{legend.ncol}{Optionally, the number of columns in the legend.  Defaults to 2.}

\item{legend.cex}{Optionally, character expansion for the legend.  Defaults to 1.}

\item{gap}{Optionally, The space between chromosomes in Mb.  Defaults to 25.}

\item{incl.markers}{Optionally, whether to draw a rug plot along the bottom indicating where the markers are.  Defaults to TRUE.}

\item{title}{Optionally, title for plot.  Defaults to phenotype from scanonevar object.}

\item{title.cex}{Optionally, title character expansion.  Defaults to 1.5}

\item{ylim}{Optionally, the y limits for the plot.  Defaults to \code{c(0, 1.05 * highest.point)}.}

\item{show.equations}{Optionally, whether to write the modeling equations under the title.  Defaults to TRUE.}

\item{alpha.side}{Optionally, side to print 'alpha=0.05' and 'alpha=0.01' on the thresholds.  Defaults to 'left'.  Other option is 'right'}

\item{line.width}{Optionally, width of plotted lines.  Defaults to 1.}

\item{vertical.bar}{Optionally, location to plot vertical line to draw attention to one peak.  Defaults to NA.}

\item{...}{optional graphical parameters}
}
\value{
Returns nothing.  Only makes the plot.
}
\description{
\code{plot.scanonevar} implements the plot generic for objects of class 'scanonevar'.
   Because scanonevar objects can be viewed in terms of LODs or empirical p-values,
   this plotting function checks the 'units' attribute to determine which to plot.
}
\details{


If such a strong signal was observed that the empirical p-value underflows R's
   float type, this function produces an error.  The author is open to suggestions on how
   to deal with this situation better.

   These plots look a lot better when both x (the scanone.var object) and y (optional scanone
   for comparison) are in units of empirical p values than when they are in LOD units.
}
\examples{
set.seed(27599)
   my.cross <- sim.cross(map = sim.map(), type = 'f2')
   my.cross$pheno$phenotype <- rnorm(n = 100,
                                     mean = my.cross$geno$`1`$data[,5],
                                     sd = my.cross$geno$`2`$data[,5])
   my.cross$pheno$sex <- rbinom(n = 100, size = 1, prob = 0.5)
   my.cross <- calc.genoprob(my.cross)

   my.scanonevar <- scanonevar(cross = my.cross,
                               mean.formula = 'phenotype ~ sex + mean.QTL.add + mean.QTL.dom',
                               var.formula = '~sex + var.QTL.add + var.QTL.dom',
                               chrs = 1:3)

   summary(my.scanonevar)

   plot(my.scanonevar)
}
\author{
Robert Corty \email{rcorty@gmail.com}
}
\seealso{
\code{\link{scanonevar}}, \code{\link{scanonevar.to.p.values}}
}

