% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_table_nm.R
\name{read_table_nm}
\alias{read_table_nm}
\title{NONMEM output table import function}
\usage{
read_table_nm(file = NULL, skip = NULL, header = NULL,
  rm_duplicates = FALSE, nonmem_tab = TRUE)
}
\arguments{
\item{file}{full file name}

\item{skip}{number of lines to skip before reading data}

\item{header}{logical value indicating whether the file contains the names
of the variables as its first line}

\item{rm_duplicates}{logical value indicating whether duplicated columns should be removed}

\item{nonmem_tab}{logical value indicating to the function whether the file is a
table or a nonmem additional output file.}
}
\value{
A \code{data.frame}
}
\description{
Quickly import NONMEM output tables into R.
Function taken from `modelviz` package by Benjamin Guiastrennec.
When both \code{skip} and \code{header} are \code{NULL},
\code{read_nmtab} will automatically detect the optimal
settings to import the tables. When more than one files are
provided for a same NONMEM run, they will be combined into
a single \code{data.frame}.
}
\examples{
\dontrun{
data <- read_table_nm(file = '../models/pk/sdtab101')
}
}
