% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data.R
\name{sim_data}
\alias{sim_data}
\title{Simulate data based on a model and parameter distributions}
\usage{
sim_data(design = cbind(id = c(1, 1, 1), idv = c(0, 1, 2)),
  model = function(x) {     return(x$alpha + x$beta) }, theta, omega_mat,
  par_names, par_values = NULL, draw_iiv = "mvrnorm",
  error = list(proportional = 0, additive = 0, exponential = 0), n = 100)
}
\arguments{
\item{design}{a design dataset. See example}

\item{model}{A function with the first argument the simulation design, i.e. a dataset with the columns ... The second argument to this function is a dataset with parameters for every individual. This can be supplied by the user, or generated by this sim_data if theta and omega_mat are supplied.}

\item{theta}{vector of fixed effect parameters}

\item{omega_mat}{vector of between subject random effects, specified as lower triangle}

\item{par_names}{A character vector linking the parameters in the model to the variables in the dataset. See example.}

\item{par_values}{parameter values}

\item{draw_iiv}{draw between subject random effects?}

\item{error}{see example}

\item{n}{number of simulations to perform}
}
\value{
a vector of simulated dependent variables (for us in the VPC plotting function)
}
\description{
Simulate data based on a model and parameter distributions
}
\details{
This function generates the simulated dependent values for use in the VPC plotting function.
}
\seealso{
\code{\link{vpc}}
}
