% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{exact_vol}
\alias{exact_vol}
\title{Compute the exact volume of (a) a zonotope (b) an arbitrary simplex in V-representation or (c) if the volume is known and declared by the input object.}
\usage{
exact_vol(P)
}
\arguments{
\item{P}{A polytope}
}
\value{
The exact volume of the input polytope, for zonotopes, simplices in V-representation and polytopes with known exact volume
}
\description{
Given a zonotope (as an object of class Zonotope), this function computes the sum of the absolute values of the determinants of all the \eqn{d \times d} submatrices of the \eqn{m\times d} matrix \eqn{G} that contains row-wise the \eqn{m} \eqn{d}-dimensional segments that define the zonotope.
For an arbitrary simplex that is given in V-representation this function computes the absolute value of the determinant formed by the simplex's points assuming it is shifted to the origin.
}
\examples{

# compute the exact volume of a 5-dimensional zonotope defined by the Minkowski sum of 10 segments
Z = gen_rand_zonotope(2, 5)
vol = exact_vol(Z)

\donttest{# compute the exact volume of a 2-d arbitrary simplex
V = matrix(c(2,3,-1,7,0,0),ncol = 2, nrow = 3, byrow = TRUE)
P = Vpolytope$new(V)
vol = exact_vol(P)
}

# compute the exact volume the 10-dimensional cross polytope
P = gen_cross(10,'V')
vol = exact_vol(P)
}
\references{
\cite{E. Gover and N. Krikorian,
\dQuote{Determinants and the Volumes of Parallelotopes and Zonotopes,} \emph{Linear Algebra and its Applications, 433(1), 28 - 40,} 2010.}
}
