% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audio_time.R
\name{audio_time}
\alias{audio_time}
\title{Returns the total time of audio files in seconds}
\usage{
audio_time(x, filesRange = NULL, recursive = FALSE)
}
\arguments{
\item{x}{Either a WAV file or a directory containing WAV files.}

\item{filesRange}{The desired range of directory files (default: \code{NULL}, i.e., all files).}

\item{recursive}{Logical. Should the listing recursively into directories? (default: \code{FALSE}) Used by \code{base::list.files}.}
}
\value{
A tibble containing file name <chr> and audio time <dbl>.
}
\description{
Returns the total time of audio files in seconds
}
\examples{
library(voice)

# get path to audio file
path2wav <- list.files(system.file('extdata', package = 'wrassp'),
pattern <- glob2rx('*.wav'), full.names = TRUE)

# Tibble containing file name and audio time
(at <- voice::audio_time(unique(dirname(path2wav))))
str(at)
}
