% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_sim.R
\name{racusum_arl_h_sim}
\alias{racusum_arl_h_sim}
\title{Compute alarm threshold of RA-CUSUM control charts using simulation}
\usage{
racusum_arl_h_sim(L0, df, coeff, R0 = 1, RA = 2, m = 100,
  yemp = TRUE, nc = 1, jmax = 4, verbose = FALSE)
}
\arguments{
\item{L0}{Double. Prespecified in-control Average Run Length.}

\item{df}{Data Frame. First column are Parsonnet Score values within a range of \code{0} to
\code{100} representing the preoperative patient risk. The second column are binary (\code{0/1})
 outcome values of each operation.}

\item{coeff}{Numeric Vector. Estimated coefficients \eqn{\alpha}{alpha} and \eqn{\beta}{beta}
from the binary logistic regression model.}

\item{R0}{Double. Odds ratio of death under the null hypotheses.}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio \code{RA = 2}.
Detecting improvement in performance with decreased mortality risk by halving the odds ratio of
 death \code{RA = 1/2}.}

\item{m}{Integer. Number of simulation runs.}

\item{yemp}{Logical. If \code{TRUE}, use emirical outcome values, else use model.}

\item{nc}{Integer. Number of cores used for parallel processing.}

\item{jmax}{Integer. Number of digits for grid search.}

\item{verbose}{Logical. If \code{TRUE} verbose output is included, if \code{FALSE} a quiet
calculation of \code{h} is done.}
}
\value{
Returns a single value which is the control limit \code{h} for a given in-control ARL.
}
\description{
Compute alarm threshold of risk-adjusted cumulative sum control charts using
 simulation.
}
\details{
The function \code{racusum_arl_h_sim} determines the control limit \code{h} for given
 in-control ARL (\code{L0}) by applying a multi-stage search procedure which includes secant
 rule and the parallel version of \code{\link{racusum_arl_sim}} using \code{\link{mclapply}}.
}
\examples{
\donttest{

# This function is deprecated. See racusum_crit_sim() instead.

 }
}
\author{
Philipp Wittenberg
}
