% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_COX_HR.R
\name{get_COX_HR}
\alias{get_COX_HR}
\alias{get_COX_HR.survfit}
\title{Summarize Hazard Ratio from a survival object using S3 method}
\usage{
get_COX_HR(x, ...)

\method{get_COX_HR}{survfit}(x, update_formula = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{survfit}}

\item{...}{other arguments passed on to the method survival::coxph}

\item{update_formula}{Template which specifies how to update the formula of the survfit object \code{\link[stats]{update.formula}}}
}
\value{
A tidied object of class \code{coxph} containing Hazard Ratios
}
\description{
S3 method for extracting information regarding Hazard Ratios.
The function allows the survival object's formula to be updated.
No default method is available at the moment.
}
\examples{
## treatment effect
survfit_object_trt <- visR::estimate_KM(data = adtte, strata = c("TRTP"))
visR::get_COX_HR(survfit_object_trt)

## treatment and gender effect
survfit_object_trt_sex <- visR::estimate_KM(data = adtte, strata = c("TRTP", "SEX"))
visR::get_COX_HR(survfit_object_trt_sex)

## update formula of KM estimates by treatment to include "SEX" for HR estimation
visR::get_COX_HR(survfit_object_trt, update_formula = ". ~ . + SEX")

## update formula of KM estimates by treatment to include "AGE" for
## HR estimation with ties considered via the efron method
visR::get_COX_HR(survfit_object_trt,
  update_formula = ". ~ . + survival::strata(AGE)", ties = "efron"
)

}
\seealso{
\code{\link[survival]{coxph}} \code{\link[stats]{update.formula}}
}
