% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vos_connect.R
\name{vos_connect}
\alias{vos_connect}
\title{Connect to a Virtuoso Server over ODBC}
\usage{
vos_connect(
  driver = NULL,
  uid = "dba",
  pwd = "dba",
  host = "localhost",
  port = "1111",
  system_odbcinst = find_odbcinst(),
  local_odbcinst = odbcinst_path()
)
}
\arguments{
\item{driver}{Name of the Driver line in the ODBC configuration}

\item{uid}{User id. Defaults to "dba"}

\item{pwd}{Password. Defaults to "dba"}

\item{host}{IP address of the Virtuoso Server}

\item{port}{Port used by Virtuoso. Defaults to
the Virtuoso standard port, 1111}

\item{system_odbcinst}{Path to the system \code{odbcinst.ini} file. (Does not
require write access.) Default will attempt to find the file for your system.}

\item{local_odbcinst}{Path to the local odbcinst we should use.}
}
\value{
a DBI connection to the Virtuoso database.  This can
be passed to additional virtuoso functions such as \code{\link[=vos_import]{vos_import()}}
or \code{\link[=vos_query]{vos_query()}}, and can also be used as a standard DBI or dplyr
database backend.
}
\description{
Connect to a Virtuoso Server over ODBC
}
\details{
Default parameters are appropriate for the automatic installer
provided by the package and for the default settings typically used by
local Virtuoso installers.  Adjust these only if you are connecting to a
remote virtuoso server that is not controlled from the R package.
}
\examples{
status <- vos_status()
\donttest{
if(has_virtuoso()){
## start up
vos_start()
con <- vos_connect()
}
}
}
\seealso{
\code{\link[=vos_install]{vos_install()}}, \code{\link[=vos_start]{vos_start()}}
}
