% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vip.R
\name{vip}
\alias{vip}
\alias{vip.default}
\title{Variable Importance Plots}
\usage{
vip(object, ...)

\method{vip}{default}(object, num_features = 10L, bar = TRUE,
  width = 0.75, horizontal = TRUE, alpha = 1, color = "grey35",
  fill = "grey35", size = 1, shape = 19, ...)
}
\arguments{
\item{object}{A fitted model object (e.g., a \code{"randomForest"} object).}

\item{...}{Additional optional arguments to be passed onto \code{\link{vi}}.}

\item{num_features}{Integer specifying the number of variable importance
scores to plot. Default is \code{10}.}

\item{bar}{Logical indicating whether or not to produce a barplot. Default
is \code{TRUE}. If \code{bar = FALSE}, then a dotchart is displayed instead.}

\item{width}{Numeric value specifying the width of the bars when
\code{bar = TRUE}. Default is \code{0.75}.}

\item{horizontal}{Logical indicating whether or not to plot the importance
scores on the x-axis (\code{TRUE}). Default is \code{TRUE}.}

\item{alpha}{Numeric value between 0 and 1 giving the trasparency of the
bars.}

\item{color}{Character string specifying the color to use for the borders of
the bars. Could also be a function, such as
\code{\link[grDevices]{heat.colors}}. Default is \code{"grey35"}.}

\item{fill}{Character string specifying the color to use to fill the bars.
Could also be a function, such as \code{\link[grDevices]{heat.colors}}.
Default is \code{"grey35"}.}

\item{size}{Numeric value indicating the size to use for the points whenever
\code{bar = FALSE}. Default is \code{1}.}

\item{shape}{Numeric value indicating the shape to use for the points
whenever \code{bar = FALSE}. Default is \code{1}.}
}
\description{
Plot variable importance scores for the predictors in a model.
}
\examples{
#
# A projection pursuit regression example
#

# Load the sample data
data(mtcars)

# Fit a projection pursuit regression model
mtcars.ppr <- ppr(mpg ~ ., data = mtcars, nterms = 1)

# Construct variable importance plot
vip(mtcars.ppr, method = "ice")
}
