% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_vimp_point_est.R
\name{cv_vimp_point_est}
\alias{cv_vimp_point_est}
\title{Estimate variable importance using cross-validation}
\usage{
cv_vimp_point_est(
  full,
  reduced,
  y,
  folds,
  weights = rep(1, length(y)),
  type = "r_squared",
  na.rm = FALSE
)
}
\arguments{
\item{full}{fitted values from a regression of the outcome on the full set of covariates; a list of length V, where each object is a set of predictions on the validation data.}

\item{reduced}{fitted values from a regression of the fitted values from the full regression on the reduced set of covariates; a list of length V, where each object is a set of predictions on the validation data.}

\item{y}{the outcome.}

\item{folds}{a list of outer and inner folds (outer for hypothesis testing, inner for cross-validation)}

\item{weights}{weights for the computed influence curve (e.g., inverse probability weights for coarsened-at-random settings)}

\item{type}{which parameter are you estimating (defaults to \code{anova}, for ANOVA-based variable importance)?}

\item{na.rm}{logical; should NA's be removed in computation? (defaults to \code{FALSE})}
}
\value{
The estimated variable importance for the given group of left-out covariates.
}
\description{
Compute nonparametric estimates of the chosen variable importance parameter, with a correction for using data-adaptive techniques to estimate the conditional means only if necessary.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function and the definition of the parameter of interest.
}
