% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp_point_est.R
\name{vimp_point_est}
\alias{vimp_point_est}
\title{Estimate variable importance}
\usage{
vimp_point_est(
  full,
  reduced,
  y,
  folds,
  weights = rep(1, length(y)),
  type = "r_squared",
  na.rm = FALSE
)
}
\arguments{
\item{full}{fitted values from a regression of the outcome on the full set of covariates.}

\item{reduced}{fitted values from a regression of the fitted values from the full regression on the reduced set of covariates.}

\item{y}{the outcome.}

\item{folds}{the folds for hypothesis testing}

\item{weights}{weights for the computed influence curve (e.g., inverse probability weights for coarsened-at-random settings)}

\item{type}{which parameter are you estimating (defaults to \code{anova}, for ANOVA-based variable importance)?}

\item{na.rm}{logical; should NA's be removed in computation? (defaults to \code{FALSE})}
}
\value{
The estimated variable importance for the given group of left-out covariates.
}
\description{
Compute nonparametric estimates of the chosen variable importance parameter, with a correction for using data-adaptive techniques to estimate the conditional means only if necessary.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function and the definition of the parameter of interest.
}
