% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy-rsconnect.R
\name{vetiver_deploy_rsconnect}
\alias{vetiver_deploy_rsconnect}
\title{Deploy a vetiver model API to RStudio Connect}
\usage{
vetiver_deploy_rsconnect(
  board,
  name,
  version = NULL,
  predict_args = list(),
  appTitle = glue::glue("{name} model API"),
  ...
)
}
\arguments{
\item{board}{A pin board, created by \code{\link[pins:board_folder]{board_folder()}}, \code{\link[pins:board_rsconnect]{board_rsconnect()}},
\code{\link[pins:board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}

\item{version}{Retrieve a specific version of a pin. Use \code{\link[pins:pin_versions]{pin_versions()}} to
find out which versions are available and when they were created.}

\item{predict_args}{A list of optional arguments passed to
\code{\link[=vetiver_pr_predict]{vetiver_pr_predict()}} such as the endpoint \code{path} or prediction \code{type}.}

\item{appTitle}{The API title on RStudio Connect. Use the default based on
\code{name}, or pass in your own title.}

\item{...}{Other arguments passed to \code{\link[rsconnect:deployApp]{rsconnect::deployApp()}} such as
\code{account} or \code{launch.browser}.}
}
\value{
The deployment success (\code{TRUE} or \code{FALSE}), invisibly.
}
\description{
Use \code{vetiver_deploy_rsconnect()} to deploy a \code{\link[=vetiver_model]{vetiver_model()}} that has been
versioned and stored via \code{\link[=vetiver_pin_write]{vetiver_pin_write()}} as a Plumber API on RStudio
Connect.
}
\examples{
library(pins)
tmp <- tempfile()
b <- board_temp(versioned = TRUE)
cars_lm <- lm(mpg ~ ., data = mtcars)
v <- vetiver_model(cars_lm, "cars_linear")
vetiver_pin_write(b, v)

if (FALSE) {
vetiver_deploy_rsconnect(b, "cars_linear", predict_args = list(debug = TRUE))
}

}
\seealso{
\code{\link[=vetiver_write_plumber]{vetiver_write_plumber()}}
}
