% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mse.R
\name{get_valid_sources}
\alias{get_valid_sources}
\title{Determine valid sources for estimation of a stratum of interest.}
\usage{
get_valid_sources(stratum_data_prepped, min_n = 1)
}
\arguments{
\item{stratum_data_prepped}{A data frame with all records in a stratum of interest.
Columns indicating sources should be prefixed with \code{in_} and should be numeric
with 1 indicating that an individual was documented in the source and 0
indicating that an individual was not documented in the source.}

\item{min_n}{The minimum number of records that must appear in a source to be
considered valid for estimation. \code{min_n} should never be less than or equal
to 0; the default value is 1.}
}
\value{
A character vector containing the names of the valid sources.
}
\description{
Determine valid sources for estimation of a stratum of interest.
}
\examples{
set.seed(19481210)
in_A <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.45, 0.65))
in_B <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.5, 0.5))
in_C <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.75, 0.25))
in_D <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(1, 0))

my_stratum <- tibble::tibble(in_A, in_B, in_C, in_D)
get_valid_sources(my_stratum)
}
