% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_det.R
\name{emis_det}
\alias{emis_det}
\title{Determine deterioration factors for urban conditions}
\usage{
emis_det(po, cc, eu, km)
}
\arguments{
\item{po}{Pollutant}

\item{cc}{Size of engine in cc}

\item{eu}{Euro standard: "PRE", "I", "II", "III", "III", "IV", "V", "VI"}

\item{km}{mileage in km}
}
\value{
It returns a numeric vector without "units"
}
\description{
\code{emis_det} returns deterioration factors. The emission
factors comes from the guidelines for developing emission factors of the
EMEP/EEA air pollutant emission inventory guidebook
http://www.eea.europa.eu/themes/air/emep-eea-air-pollutant-emission-inventory-guidebook
This function subset an internal database of emission factors with each argument
}
\examples{
\dontrun{
data(fkm)
pckm <- fkm[[1]](1:24); pckma <- cumsum(pckm)
cod1 <- emis_det(po = "CO", cc = 1000, eu = "III", km = pckma[1:11])
}
}
\keyword{deterioration}
\keyword{emission}
\keyword{factors}
