# vw_fetch() works

    Code
      vw_fetch("https://vega.github.io/vega-datasets/data/anscombe.json")
    Output
      [1] "[\n  {\"Series\":\"I\", \"X\":10.0, \"Y\":8.04},\n  {\"Series\":\"I\", \"X\":8.0, \"Y\":6.95},\n  {\"Series\":\"I\", \"X\":13.0, \"Y\":7.58},\n  {\"Series\":\"I\", \"X\":9.0, \"Y\":8.81},\n  {\"Series\":\"I\", \"X\":11.0, \"Y\":8.33},\n  {\"Series\":\"I\", \"X\":14.0, \"Y\":9.96},\n  {\"Series\":\"I\", \"X\":6.0, \"Y\":7.24},\n  {\"Series\":\"I\", \"X\":4.0, \"Y\":4.26},\n  {\"Series\":\"I\", \"X\":12.0, \"Y\":10.84},\n  {\"Series\":\"I\", \"X\":7.0, \"Y\":4.81},\n  {\"Series\":\"I\", \"X\":5.0, \"Y\":5.68},\n  \n  {\"Series\":\"II\", \"X\":10.0, \"Y\":9.14},\n  {\"Series\":\"II\", \"X\":8.0, \"Y\":8.14},\n  {\"Series\":\"II\", \"X\":13.0, \"Y\":8.74},\n  {\"Series\":\"II\", \"X\":9.0, \"Y\":8.77},\n  {\"Series\":\"II\", \"X\":11.0, \"Y\":9.26},\n  {\"Series\":\"II\", \"X\":14.0, \"Y\":8.10},\n  {\"Series\":\"II\", \"X\":6.0, \"Y\":6.13},\n  {\"Series\":\"II\", \"X\":4.0, \"Y\":3.10},\n  {\"Series\":\"II\", \"X\":12.0, \"Y\":9.13},\n  {\"Series\":\"II\", \"X\":7.0, \"Y\":7.26},\n  {\"Series\":\"II\", \"X\":5.0, \"Y\":4.74},\n  \n  {\"Series\":\"III\", \"X\":10.0, \"Y\":7.46},\n  {\"Series\":\"III\", \"X\":8.0, \"Y\":6.77},\n  {\"Series\":\"III\", \"X\":13.0, \"Y\":12.74},\n  {\"Series\":\"III\", \"X\":9.0, \"Y\":7.11},\n  {\"Series\":\"III\", \"X\":11.0, \"Y\":7.81},\n  {\"Series\":\"III\", \"X\":14.0, \"Y\":8.84},\n  {\"Series\":\"III\", \"X\":6.0, \"Y\":6.08},\n  {\"Series\":\"III\", \"X\":4.0, \"Y\":5.39},\n  {\"Series\":\"III\", \"X\":12.0, \"Y\":8.15},\n  {\"Series\":\"III\", \"X\":7.0, \"Y\":6.42},\n  {\"Series\":\"III\", \"X\":5.0, \"Y\":5.73},\n  \n  {\"Series\":\"IV\", \"X\":8.0, \"Y\":6.58},\n  {\"Series\":\"IV\", \"X\":8.0, \"Y\":5.76},\n  {\"Series\":\"IV\", \"X\":8.0, \"Y\":7.71},\n  {\"Series\":\"IV\", \"X\":8.0, \"Y\":8.84},\n  {\"Series\":\"IV\", \"X\":8.0, \"Y\":8.47},\n  {\"Series\":\"IV\", \"X\":8.0, \"Y\":7.04},\n  {\"Series\":\"IV\", \"X\":8.0, \"Y\":5.25},\n  {\"Series\":\"IV\", \"X\":19.0, \"Y\":12.50},\n  {\"Series\":\"IV\", \"X\":8.0, \"Y\":5.56},\n  {\"Series\":\"IV\", \"X\":8.0, \"Y\":7.91},\n  {\"Series\":\"IV\", \"X\":8.0, \"Y\":6.89}\n]"

---

    Code
      ct$assign("url", "https://vega.github.io/vega-datasets/data/anscombe.json")
      ct$eval("(async () => {result = await vwFetch(url, {response: 'json'});})()")
    Output
      [1] "[object Promise]"
    Code
      ct$eval("console.log(JSON.stringify(result))")
    Output
      [{"Series":"I","X":10,"Y":8.04},{"Series":"I","X":8,"Y":6.95},{"Series":"I","X":13,"Y":7.58},{"Series":"I","X":9,"Y":8.81},{"Series":"I","X":11,"Y":8.33},{"Series":"I","X":14,"Y":9.96},{"Series":"I","X":6,"Y":7.24},{"Series":"I","X":4,"Y":4.26},{"Series":"I","X":12,"Y":10.84},{"Series":"I","X":7,"Y":4.81},{"Series":"I","X":5,"Y":5.68},{"Series":"II","X":10,"Y":9.14},{"Series":"II","X":8,"Y":8.14},{"Series":"II","X":13,"Y":8.74},{"Series":"II","X":9,"Y":8.77},{"Series":"II","X":11,"Y":9.26},{"Series":"II","X":14,"Y":8.1},{"Series":"II","X":6,"Y":6.13},{"Series":"II","X":4,"Y":3.1},{"Series":"II","X":12,"Y":9.13},{"Series":"II","X":7,"Y":7.26},{"Series":"II","X":5,"Y":4.74},{"Series":"III","X":10,"Y":7.46},{"Series":"III","X":8,"Y":6.77},{"Series":"III","X":13,"Y":12.74},{"Series":"III","X":9,"Y":7.11},{"Series":"III","X":11,"Y":7.81},{"Series":"III","X":14,"Y":8.84},{"Series":"III","X":6,"Y":6.08},{"Series":"III","X":4,"Y":5.39},{"Series":"III","X":12,"Y":8.15},{"Series":"III","X":7,"Y":6.42},{"Series":"III","X":5,"Y":5.73},{"Series":"IV","X":8,"Y":6.58},{"Series":"IV","X":8,"Y":5.76},{"Series":"IV","X":8,"Y":7.71},{"Series":"IV","X":8,"Y":8.84},{"Series":"IV","X":8,"Y":8.47},{"Series":"IV","X":8,"Y":7.04},{"Series":"IV","X":8,"Y":5.25},{"Series":"IV","X":19,"Y":12.5},{"Series":"IV","X":8,"Y":5.56},{"Series":"IV","X":8,"Y":7.91},{"Series":"IV","X":8,"Y":6.89}]

---

    Code
      ct$assign("url",
        "https://vega.github.io/vega-datasets/data/seattle-weather.csv")
      ct$eval("(async () => {result = await vwFetch(url, {response: 'text'});})()")
    Output
      [1] "[object Promise]"
    Code
      ct$eval("console.log(result)")
    Output
      date,precipitation,temp_max,temp_min,wind,weather
      2012-01-01,0.0,12.8,5.0,4.7,drizzle
      2012-01-02,10.9,10.6,2.8,4.5,rain
      2012-01-03,0.8,11.7,7.2,2.3,rain
      2012-01-04,20.3,12.2,5.6,4.7,rain
      2012-01-05,1.3,8.9,2.8,6.1,rain
      2012-01-06,2.5,4.4,2.2,2.2,rain
      2012-01-07,0.0,7.2,2.8,2.3,rain
      2012-01-08,0.0,10.0,2.8,2.0,sun
      2012-01-09,4.3,9.4,5.0,3.4,rain
      2012-01-10,1.0,6.1,0.6,3.4,rain
      2012-01-11,0.0,6.1,-1.1,5.1,sun
      2012-01-12,0.0,6.1,-1.7,1.9,sun
      2012-01-13,0.0,5.0,-2.8,1.3,sun
      2012-01-14,4.1,4.4,0.6,5.3,snow
      2012-01-15,5.3,1.1,-3.3,3.2,snow
      2012-01-16,2.5,1.7,-2.8,5.0,snow
      2012-01-17,8.1,3.3,0.0,5.6,snow
      2012-01-18,19.8,0.0,-2.8,5.0,snow
      2012-01-19,15.2,-1.1,-2.8,1.6,snow
      2012-01-20,13.5,7.2,-1.1,2.3,snow
      2012-01-21,3.0,8.3,3.3,8.2,rain
      2012-01-22,6.1,6.7,2.2,4.8,rain
      2012-01-23,0.0,8.3,1.1,3.6,rain
      2012-01-24,8.6,10.0,2.2,5.1,rain
      2012-01-25,8.1,8.9,4.4,5.4,rain
      2012-01-26,4.8,8.9,1.1,4.8,rain
      2012-01-27,0.0,6.7,-2.2,1.4,drizzle
      2012-01-28,0.0,6.7,0.6,2.2,rain
      2012-01-29,27.7,9.4,3.9,4.5,rain
      2012-01-30,3.6,8.3,6.1,5.1,rain
      2012-01-31,1.8,9.4,6.1,3.9,rain
      2012-02-01,13.5,8.9,3.3,2.7,rain
      2012-02-02,0.0,8.3,1.7,2.6,sun
      2012-02-03,0.0,14.4,2.2,5.3,sun
      2012-02-04,0.0,15.6,5.0,4.3,sun
      2012-02-05,0.0,13.9,1.7,2.9,sun
      2012-02-06,0.0,16.1,1.7,5.0,sun
      2012-02-07,0.3,15.6,7.8,5.3,rain
      2012-02-08,2.8,10.0,5.0,2.7,rain
      2012-02-09,2.5,11.1,7.8,2.4,rain
      2012-02-10,2.5,12.8,6.7,3.0,rain
      2012-02-11,0.8,8.9,5.6,3.4,rain
      2012-02-12,1.0,8.3,5.0,1.3,rain
      2012-02-13,11.4,7.2,4.4,1.4,rain
      2012-02-14,2.5,6.7,1.1,3.1,rain
      2012-02-15,0.0,7.2,0.6,1.8,drizzle
      2012-02-16,1.8,7.2,3.3,2.1,rain
      2012-02-17,17.3,10.0,4.4,3.4,rain
      2012-02-18,6.4,6.7,3.9,8.1,rain
      2012-02-19,0.0,6.7,2.2,4.7,sun
      2012-02-20,3.0,7.8,1.7,2.9,rain
      2012-02-21,0.8,10.0,7.8,7.5,rain
      2012-02-22,8.6,10.0,2.8,5.9,rain
      2012-02-23,0.0,8.3,2.8,3.9,sun
      2012-02-24,11.4,6.7,4.4,3.5,rain
      2012-02-25,0.0,7.2,2.8,6.4,rain
      2012-02-26,1.3,5.0,-1.1,3.4,snow
      2012-02-27,0.0,6.7,-2.2,3.0,sun
      2012-02-28,3.6,6.7,-0.6,4.2,snow
      2012-02-29,0.8,5.0,1.1,7.0,snow
      2012-03-01,0.0,6.1,1.1,3.1,sun
      2012-03-02,2.0,6.7,3.9,5.1,rain
      2012-03-03,0.0,12.2,6.7,7.0,sun
      2012-03-04,0.0,10.6,6.7,5.6,rain
      2012-03-05,6.9,7.8,1.1,6.2,rain
      2012-03-06,0.5,6.7,0.0,2.7,snow
      2012-03-07,0.0,8.9,-1.7,2.7,sun
      2012-03-08,0.0,15.6,0.6,2.5,sun
      2012-03-09,3.6,9.4,5.0,2.8,rain
      2012-03-10,10.4,7.2,6.1,3.4,rain
      2012-03-11,13.7,6.7,2.8,5.8,rain
      2012-03-12,19.3,8.3,0.6,6.2,snow
      2012-03-13,9.4,5.6,0.6,5.3,snow
      2012-03-14,8.6,7.8,1.1,4.7,rain
      2012-03-15,23.9,11.1,5.6,5.8,snow
      2012-03-16,8.4,8.9,3.9,5.1,rain
      2012-03-17,9.4,10.0,0.6,3.8,snow
      2012-03-18,3.6,5.0,-0.6,2.7,rain
      2012-03-19,2.0,7.2,-1.1,3.0,rain
      2012-03-20,3.6,7.8,2.2,6.4,rain
      2012-03-21,1.3,8.9,1.1,2.5,rain
      2012-03-22,4.1,10.0,1.7,2.1,rain
      2012-03-23,0.0,12.2,0.6,2.8,sun
      2012-03-24,0.0,15.0,3.3,5.2,sun
      2012-03-25,0.0,13.3,2.2,2.7,rain
      2012-03-26,0.0,12.8,6.1,4.3,drizzle
      2012-03-27,4.8,14.4,6.7,3.8,rain
      2012-03-28,1.3,10.6,7.2,5.9,rain
      2012-03-29,27.4,10.0,6.1,4.4,rain
      2012-03-30,5.6,9.4,5.0,4.7,rain
      2012-03-31,13.2,10.0,2.8,3.4,rain
      2012-04-01,1.5,8.9,4.4,6.8,rain
      2012-04-02,0.0,16.7,4.4,3.1,sun
      2012-04-03,1.5,11.7,3.3,3.1,rain
      2012-04-04,0.0,10.6,2.8,2.1,sun
      2012-04-05,4.6,9.4,2.8,1.8,snow
      2012-04-06,0.3,11.1,3.3,2.6,rain
      2012-04-07,0.0,16.1,1.7,4.3,sun
      2012-04-08,0.0,21.1,7.2,4.1,sun
      2012-04-09,0.0,20.0,6.1,2.1,sun
      2012-04-10,0.0,17.8,8.9,3.2,rain
      2012-04-11,2.3,11.1,7.2,2.6,rain
      2012-04-12,0.5,13.9,5.6,2.6,rain
      2012-04-13,0.0,15.0,3.9,4.0,drizzle
      2012-04-14,0.0,15.6,3.3,3.0,sun
      2012-04-15,0.0,16.1,7.2,2.9,rain
      2012-04-16,8.1,13.3,6.7,5.8,rain
      2012-04-17,1.8,10.0,4.4,2.0,rain
      2012-04-18,1.8,13.3,7.2,3.9,rain
      2012-04-19,10.9,13.9,5.0,2.6,rain
      2012-04-20,6.6,13.3,6.7,2.7,rain
      2012-04-21,0.0,20.0,4.4,2.3,sun
      2012-04-22,0.0,23.3,8.3,2.6,rain
      2012-04-23,0.0,21.7,8.9,3.5,sun
      2012-04-24,4.3,13.9,10.0,2.8,rain
      2012-04-25,10.7,16.7,8.9,2.6,rain
      2012-04-26,3.8,13.9,6.7,5.2,rain
      2012-04-27,0.8,13.3,6.1,4.8,rain
      2012-04-28,0.0,16.1,8.3,2.5,drizzle
      2012-04-29,4.3,15.6,8.9,1.6,rain
      2012-04-30,4.3,12.8,7.2,8.0,rain
      2012-05-01,0.5,11.7,6.1,6.4,rain
      2012-05-02,0.5,13.3,5.6,2.5,rain
      2012-05-03,18.5,11.1,7.2,3.4,rain
      2012-05-04,1.8,12.2,6.1,4.6,rain
      2012-05-05,0.0,13.3,5.0,2.3,sun
      2012-05-06,0.0,17.8,5.0,2.4,sun
      2012-05-07,0.0,23.9,6.1,2.2,sun
      2012-05-08,0.0,18.3,9.4,3.0,sun
      2012-05-09,0.0,13.3,6.7,3.9,rain
      2012-05-10,0.0,14.4,3.9,3.0,sun
      2012-05-11,0.0,18.3,4.4,4.3,sun
      2012-05-12,0.0,24.4,6.7,3.4,sun
      2012-05-13,0.0,25.6,9.4,4.2,sun
      2012-05-14,0.0,26.7,12.8,3.8,sun
      2012-05-15,0.0,24.4,9.4,4.1,drizzle
      2012-05-16,0.0,19.4,9.4,3.5,sun
      2012-05-17,0.0,17.8,6.7,2.9,rain
      2012-05-18,0.0,15.6,7.8,3.1,rain
      2012-05-19,0.0,19.4,7.2,1.5,sun
      2012-05-20,6.4,14.4,11.7,1.3,rain
      2012-05-21,14.0,16.7,10.0,4.0,rain
      2012-05-22,6.1,12.8,8.9,4.8,rain
      2012-05-23,0.3,14.4,8.9,6.3,rain
      2012-05-24,0.0,17.2,8.9,3.3,rain
      2012-05-25,0.0,22.2,8.9,3.1,rain
      2012-05-26,0.0,22.2,8.9,3.6,sun
      2012-05-27,0.0,17.2,11.7,3.7,sun
      2012-05-28,0.0,16.7,10.0,3.4,rain
      2012-05-29,0.0,16.1,7.8,1.8,sun
      2012-05-30,0.3,18.9,11.1,1.5,rain
      2012-05-31,3.8,17.8,12.2,2.7,rain
      2012-06-01,6.6,20.0,12.8,3.7,rain
      2012-06-02,0.3,18.9,10.6,3.7,rain
      2012-06-03,0.0,17.2,9.4,2.9,sun
      2012-06-04,1.3,12.8,8.9,3.1,rain
      2012-06-05,16.0,13.3,8.3,3.3,rain
      2012-06-06,0.0,16.1,6.1,3.4,sun
      2012-06-07,16.5,16.1,8.9,3.5,rain
      2012-06-08,1.5,15.0,8.3,3.0,rain
      2012-06-09,0.0,17.2,8.3,4.7,rain
      2012-06-10,0.0,18.9,10.0,2.9,sun
      2012-06-11,0.0,23.3,10.0,1.8,rain
      2012-06-12,0.8,18.3,12.8,3.9,rain
      2012-06-13,0.0,16.1,11.1,4.3,sun
      2012-06-14,0.0,17.2,10.0,2.7,sun
      2012-06-15,0.0,22.2,9.4,1.7,sun
      2012-06-16,0.0,21.1,15.0,4.1,rain
      2012-06-17,0.0,18.9,11.7,6.4,sun
      2012-06-18,3.0,17.2,10.0,3.8,rain
      2012-06-19,1.0,19.4,10.0,3.0,rain
      2012-06-20,0.0,24.4,10.0,3.0,sun
      2012-06-21,0.0,23.9,11.7,2.1,sun
      2012-06-22,15.7,13.9,11.7,1.9,rain
      2012-06-23,8.6,15.6,9.4,2.5,rain
      2012-06-24,0.0,19.4,9.4,2.0,drizzle
      2012-06-25,0.5,19.4,11.1,3.1,rain
      2012-06-26,0.0,18.3,10.6,3.4,rain
      2012-06-27,0.0,22.8,8.9,1.8,sun
      2012-06-28,0.0,22.2,11.7,2.5,rain
      2012-06-29,0.3,21.7,15.0,1.9,rain
      2012-06-30,3.0,20.0,13.3,2.4,rain
      2012-07-01,0.0,20.0,12.2,2.3,rain
      2012-07-02,2.0,18.9,11.7,2.1,rain
      2012-07-03,5.8,18.3,10.6,6.0,rain
      2012-07-04,0.0,20.6,9.4,3.8,sun
      2012-07-05,0.0,24.4,10.6,3.1,drizzle
      2012-07-06,0.0,25.0,11.1,2.1,sun
      2012-07-07,0.0,26.7,12.8,3.8,sun
      2012-07-08,0.0,28.3,14.4,2.8,rain
      2012-07-09,1.5,25.0,12.8,2.0,rain
      2012-07-10,0.0,23.9,11.1,2.3,drizzle
      2012-07-11,0.0,27.8,13.3,2.9,fog
      2012-07-12,0.0,25.6,13.3,2.7,drizzle
      2012-07-13,0.5,23.3,13.9,2.2,rain
      2012-07-14,0.0,25.0,15.0,2.2,rain
      2012-07-15,0.0,18.9,13.3,3.8,rain
      2012-07-16,0.3,26.1,13.3,2.5,rain
      2012-07-17,0.0,21.7,15.0,2.6,sun
      2012-07-18,0.0,21.1,14.4,2.9,sun
      2012-07-19,0.0,25.0,14.4,2.2,sun
      2012-07-20,15.2,19.4,13.9,4.0,rain
      2012-07-21,0.0,23.9,13.9,2.3,sun
      2012-07-22,1.0,20.6,12.2,3.9,rain
      2012-07-23,0.0,18.9,11.1,3.3,rain
      2012-07-24,0.0,23.3,12.2,4.3,sun
      2012-07-25,0.0,26.7,12.8,2.6,sun
      2012-07-26,0.0,25.6,12.8,2.2,drizzle
      2012-07-27,0.0,18.9,13.9,2.8,drizzle
      2012-07-28,0.0,22.2,13.3,1.7,drizzle
      2012-07-29,0.0,22.8,15.0,2.0,sun
      2012-07-30,0.0,19.4,13.3,3.0,sun
      2012-07-31,0.0,22.8,13.9,2.8,sun
      2012-08-01,0.0,23.9,13.3,2.2,drizzle
      2012-08-02,0.0,23.3,12.2,2.5,sun
      2012-08-03,0.0,27.2,12.8,3.9,sun
      2012-08-04,0.0,33.9,16.7,3.7,sun
      2012-08-05,0.0,33.9,17.8,1.9,sun
      2012-08-06,0.0,28.3,15.6,2.5,rain
      2012-08-07,0.0,21.1,15.0,2.6,drizzle
      2012-08-08,0.0,22.2,15.0,3.1,sun
      2012-08-09,0.0,24.4,14.4,3.8,drizzle
      2012-08-10,0.0,25.6,12.2,2.3,sun
      2012-08-11,0.0,28.3,13.3,2.5,sun
      2012-08-12,0.0,30.6,15.0,3.0,sun
      2012-08-13,0.0,30.6,15.0,2.8,sun
      2012-08-14,0.0,28.9,13.9,2.8,sun
      2012-08-15,0.0,31.1,16.7,4.7,sun
      2012-08-16,0.0,34.4,18.3,2.8,sun
      2012-08-17,0.0,32.8,16.1,1.8,sun
      2012-08-18,0.0,21.7,14.4,3.0,drizzle
      2012-08-19,0.0,23.3,15.0,2.7,drizzle
      2012-08-20,0.0,25.6,15.0,1.9,sun
      2012-08-21,0.0,23.3,13.3,3.0,rain
      2012-08-22,0.0,22.2,13.3,2.3,sun
      2012-08-23,0.0,21.1,13.9,3.8,sun
      2012-08-24,0.0,22.2,10.0,3.3,sun
      2012-08-25,0.0,26.1,11.7,3.2,sun
      2012-08-26,0.0,21.1,12.2,3.4,sun
      2012-08-27,0.0,23.9,13.3,1.8,sun
      2012-08-28,0.0,22.8,12.2,3.2,sun
      2012-08-29,0.0,22.8,13.3,2.4,sun
      2012-08-30,0.0,22.8,12.8,1.9,sun
      2012-08-31,0.0,22.2,10.6,2.9,sun
      2012-09-01,0.0,21.7,10.6,2.1,sun
      2012-09-02,0.0,21.1,10.0,2.0,sun
      2012-09-03,0.0,22.8,12.8,3.3,sun
      2012-09-04,0.0,24.4,11.1,3.1,sun
      2012-09-05,0.0,26.1,11.7,2.6,sun
      2012-09-06,0.0,28.3,14.4,4.2,sun
      2012-09-07,0.0,32.2,13.3,3.1,sun
      2012-09-08,0.0,25.0,13.3,3.0,sun
      2012-09-09,0.3,18.9,13.9,5.0,rain
      2012-09-10,0.3,20.0,11.7,3.9,rain
      2012-09-11,0.0,20.0,8.9,4.2,sun
      2012-09-12,0.0,22.2,10.0,5.6,sun
      2012-09-13,0.0,27.8,11.7,3.6,sun
      2012-09-14,0.0,26.1,11.1,1.5,sun
      2012-09-15,0.0,22.2,11.1,1.9,sun
      2012-09-16,0.0,24.4,9.4,2.3,sun
      2012-09-17,0.0,27.8,11.7,2.2,fog
      2012-09-18,0.0,27.8,11.7,1.4,sun
      2012-09-19,0.0,23.9,11.7,1.9,drizzle
      2012-09-20,0.0,19.4,10.0,2.5,drizzle
      2012-09-21,0.0,16.1,12.8,2.1,drizzle
      2012-09-22,0.3,19.4,11.7,1.1,rain
      2012-09-23,0.0,19.4,10.0,1.4,fog
      2012-09-24,0.0,21.1,10.0,1.8,fog
      2012-09-25,0.0,19.4,11.1,1.7,sun
      2012-09-26,0.0,19.4,9.4,1.7,drizzle
      2012-09-27,0.0,22.8,10.0,1.7,drizzle
      2012-09-28,0.0,25.0,12.2,1.1,rain
      2012-09-29,0.0,20.6,12.2,4.3,sun
      2012-09-30,0.0,21.1,7.8,3.1,sun
      2012-10-01,0.0,23.3,8.9,3.0,sun
      2012-10-02,0.0,17.8,10.0,4.1,sun
      2012-10-03,0.0,18.9,7.8,7.3,sun
      2012-10-04,0.0,18.9,8.3,6.5,sun
      2012-10-05,0.0,21.7,8.9,5.7,sun
      2012-10-06,0.0,23.9,7.8,5.1,sun
      2012-10-07,0.0,23.9,7.8,1.3,sun
      2012-10-08,0.0,21.1,7.8,1.9,sun
      2012-10-09,0.0,16.1,8.9,1.6,drizzle
      2012-10-10,0.0,12.2,8.3,1.4,drizzle
      2012-10-11,0.0,13.9,7.2,1.3,drizzle
      2012-10-12,2.0,13.9,8.9,4.6,rain
      2012-10-13,4.8,15.6,12.2,3.9,rain
      2012-10-14,16.5,17.8,13.3,3.4,rain
      2012-10-15,7.9,17.2,11.1,4.6,rain
      2012-10-16,0.0,16.1,8.3,5.5,sun
      2012-10-17,0.0,14.4,6.1,1.6,sun
      2012-10-18,20.8,17.8,6.7,2.0,rain
      2012-10-19,4.8,15.0,9.4,5.3,rain
      2012-10-20,0.5,11.1,6.1,5.7,rain
      2012-10-21,6.4,11.7,4.4,2.7,rain
      2012-10-22,8.9,7.8,3.3,2.6,rain
      2012-10-23,0.0,11.1,5.6,3.0,rain
      2012-10-24,7.1,11.7,6.1,2.1,rain
      2012-10-25,0.0,11.7,6.7,1.5,sun
      2012-10-26,1.5,11.1,7.2,2.5,rain
      2012-10-27,23.1,14.4,9.4,5.1,rain
      2012-10-28,6.1,14.4,10.0,3.8,rain
      2012-10-29,10.9,15.6,10.0,4.9,rain
      2012-10-30,34.5,15.0,12.2,2.8,rain
      2012-10-31,14.5,15.6,11.1,2.7,rain
      2012-11-01,9.7,15.0,10.6,3.0,rain
      2012-11-02,5.6,15.0,10.6,1.0,rain
      2012-11-03,0.5,15.6,11.1,3.6,rain
      2012-11-04,8.1,17.8,12.8,3.8,rain
      2012-11-05,0.8,15.0,7.8,4.0,rain
      2012-11-06,0.3,12.8,6.7,3.5,rain
      2012-11-07,0.0,12.2,3.9,3.4,rain
      2012-11-08,0.0,10.0,1.1,3.4,rain
      2012-11-09,0.0,8.9,1.1,2.0,rain
      2012-11-10,0.0,7.8,-0.6,2.2,sun
      2012-11-11,15.2,8.9,1.1,3.0,rain
      2012-11-12,3.6,12.8,6.1,3.0,rain
      2012-11-13,5.3,11.1,7.8,2.5,rain
      2012-11-14,0.8,11.1,5.0,2.6,rain
      2012-11-15,0.0,9.4,2.8,2.4,drizzle
      2012-11-16,5.6,9.4,2.2,1.6,rain
      2012-11-17,6.1,12.2,6.1,5.3,rain
      2012-11-18,7.9,10.0,6.1,4.9,rain
      2012-11-19,54.1,13.3,8.3,6.0,rain
      2012-11-20,3.8,11.1,7.2,4.2,rain
      2012-11-21,11.2,8.3,3.9,5.5,rain
      2012-11-22,0.0,8.9,2.8,1.5,rain
      2012-11-23,32.0,9.4,6.1,2.4,rain
      2012-11-24,0.0,8.9,3.9,1.2,rain
      2012-11-25,0.0,8.3,1.1,3.6,drizzle
      2012-11-26,0.0,9.4,1.7,3.8,fog
      2012-11-27,0.0,10.0,1.7,1.5,sun
      2012-11-28,2.8,9.4,2.2,2.9,rain
      2012-11-29,1.5,12.8,7.8,4.2,rain
      2012-11-30,35.6,15.0,7.8,4.6,rain
      2012-12-01,4.1,13.3,8.3,5.5,rain
      2012-12-02,19.6,8.3,7.2,6.2,rain
      2012-12-03,13.0,9.4,7.2,4.4,rain
      2012-12-04,14.2,11.7,7.2,6.2,rain
      2012-12-05,1.5,8.9,4.4,5.0,rain
      2012-12-06,1.5,7.2,6.1,5.1,rain
      2012-12-07,1.0,7.8,3.3,4.6,rain
      2012-12-08,0.0,6.7,3.3,2.0,sun
      2012-12-09,1.5,6.7,2.8,2.1,rain
      2012-12-10,0.5,7.2,5.6,1.8,rain
      2012-12-11,3.0,7.8,5.6,4.5,rain
      2012-12-12,8.1,6.7,4.4,2.0,rain
      2012-12-13,2.3,7.2,3.3,2.8,rain
      2012-12-14,7.9,6.1,1.1,1.7,rain
      2012-12-15,5.3,4.4,0.6,5.1,snow
      2012-12-16,22.6,6.7,3.3,5.5,snow
      2012-12-17,2.0,8.3,1.7,9.5,rain
      2012-12-18,3.3,3.9,0.6,5.3,snow
      2012-12-19,13.7,8.3,1.7,5.8,snow
      2012-12-20,13.2,7.2,0.6,3.7,rain
      2012-12-21,1.8,8.3,-1.7,1.7,rain
      2012-12-22,3.3,8.3,3.9,3.5,rain
      2012-12-23,6.6,7.2,3.3,2.5,rain
      2012-12-24,0.3,5.6,2.8,2.8,rain
      2012-12-25,13.5,5.6,2.8,4.2,snow
      2012-12-26,4.6,6.7,3.3,4.9,rain
      2012-12-27,4.1,7.8,3.3,3.2,rain
      2012-12-28,0.0,8.3,3.9,1.7,rain
      2012-12-29,1.5,5.0,3.3,1.7,rain
      2012-12-30,0.0,4.4,0.0,1.8,drizzle
      2012-12-31,0.0,3.3,-1.1,2.0,drizzle
      2013-01-01,0.0,5.0,-2.8,2.7,sun
      2013-01-02,0.0,6.1,-1.1,3.2,sun
      2013-01-03,4.1,6.7,-1.7,3.0,rain
      2013-01-04,2.5,10.0,2.2,2.8,rain
      2013-01-05,3.0,6.7,4.4,3.1,rain
      2013-01-06,2.0,7.2,2.8,3.0,rain
      2013-01-07,2.3,10.0,4.4,7.3,rain
      2013-01-08,16.3,11.7,5.6,6.3,rain
      2013-01-09,38.4,10.0,1.7,5.1,rain
      2013-01-10,0.3,3.3,-0.6,2.1,snow
      2013-01-11,0.0,2.8,-2.8,1.9,drizzle
      2013-01-12,0.0,2.8,-3.9,2.0,sun
      2013-01-13,0.0,2.2,-4.4,1.5,sun
      2013-01-14,0.0,3.3,-2.2,1.3,sun
      2013-01-15,0.0,6.7,-0.6,2.3,sun
      2013-01-16,0.0,6.1,-3.9,1.8,drizzle
      2013-01-17,0.0,3.9,-2.8,1.0,drizzle
      2013-01-18,0.0,3.3,-1.1,1.3,drizzle
      2013-01-19,0.0,1.1,-0.6,1.9,drizzle
      2013-01-20,0.0,3.3,-0.6,2.1,drizzle
      2013-01-21,0.0,2.2,-1.7,1.1,drizzle
      2013-01-22,0.0,3.3,-1.7,0.6,drizzle
      2013-01-23,5.1,7.2,2.2,3.1,rain
      2013-01-24,5.8,7.2,1.1,2.6,rain
      2013-01-25,3.0,10.6,2.8,2.1,rain
      2013-01-26,2.3,8.3,3.9,4.5,rain
      2013-01-27,1.8,5.6,3.9,4.5,rain
      2013-01-28,7.9,6.1,3.3,3.2,rain
      2013-01-29,4.3,8.3,5.0,3.9,rain
      2013-01-30,3.6,8.9,6.7,3.9,rain
      2013-01-31,3.0,9.4,7.2,4.0,rain
      2013-02-01,0.3,11.7,5.0,2.9,rain
      2013-02-02,0.0,6.1,2.8,2.0,drizzle
      2013-02-03,2.3,8.9,2.8,2.9,rain
      2013-02-04,0.0,10.6,6.7,2.6,rain
      2013-02-05,3.3,10.0,6.7,5.1,rain
      2013-02-06,1.0,10.6,6.1,4.5,rain
      2013-02-07,1.3,9.4,3.3,4.1,rain
      2013-02-08,0.0,7.8,2.2,1.3,sun
      2013-02-09,0.3,8.3,4.4,1.3,rain
      2013-02-10,0.0,8.9,1.7,2.0,drizzle
      2013-02-11,0.3,8.3,4.4,1.4,rain
      2013-02-12,1.0,11.1,7.2,5.6,rain
      2013-02-13,2.3,9.4,7.2,4.1,rain
      2013-02-14,1.0,9.4,5.6,2.2,rain
      2013-02-15,0.0,13.3,5.0,2.4,drizzle
      2013-02-16,0.0,11.1,3.9,5.6,rain
      2013-02-17,0.0,9.4,4.4,3.4,rain
      2013-02-18,0.0,7.8,3.9,1.9,rain
      2013-02-19,0.0,10.6,1.7,3.4,sun
      2013-02-20,1.5,7.8,1.1,2.1,rain
      2013-02-21,0.5,6.7,3.9,6.2,rain
      2013-02-22,9.4,7.8,3.9,8.1,rain
      2013-02-23,0.3,10.0,3.9,4.6,rain
      2013-02-24,0.0,8.9,5.0,5.5,rain
      2013-02-25,2.3,10.6,3.3,7.1,rain
      2013-02-26,0.5,8.9,3.9,3.8,rain
      2013-02-27,4.6,10.0,4.4,1.8,rain
      2013-02-28,8.1,11.7,6.7,3.8,rain
      2013-03-01,4.1,15.0,11.1,5.4,rain
      2013-03-02,0.8,13.9,5.0,4.5,rain
      2013-03-03,0.0,11.1,2.2,2.8,sun
      2013-03-04,0.0,13.3,0.0,3.9,sun
      2013-03-05,0.0,9.4,6.1,2.4,rain
      2013-03-06,11.9,7.2,5.0,4.1,rain
      2013-03-07,7.4,12.2,5.0,2.5,rain
      2013-03-08,0.0,11.7,2.2,2.6,drizzle
      2013-03-09,0.0,12.8,1.1,1.3,fog
      2013-03-10,0.8,7.8,3.9,1.6,rain
      2013-03-11,1.3,10.6,6.1,1.1,rain
      2013-03-12,2.0,12.8,10.0,5.7,rain
      2013-03-13,2.3,11.7,9.4,3.7,rain
      2013-03-14,2.8,11.7,9.4,3.0,rain
      2013-03-15,0.0,14.4,8.9,4.3,rain
      2013-03-16,4.3,10.6,4.4,6.4,rain
      2013-03-17,0.0,8.9,3.9,6.1,sun
      2013-03-18,0.0,11.7,3.9,5.9,rain
      2013-03-19,11.7,12.8,1.7,3.4,rain
      2013-03-20,9.9,11.1,4.4,7.6,rain
      2013-03-21,8.1,10.0,2.2,4.9,snow
      2013-03-22,0.0,9.4,0.6,2.2,sun
      2013-03-23,0.0,10.0,1.1,2.6,sun
      2013-03-24,0.0,12.2,0.6,2.1,sun
      2013-03-25,0.0,16.7,4.4,2.8,sun
      2013-03-26,0.0,16.7,6.1,1.7,sun
      2013-03-27,0.3,13.3,7.2,1.6,rain
      2013-03-28,2.0,16.1,8.3,1.3,rain
      2013-03-29,0.0,18.3,7.8,2.5,rain
      2013-03-30,0.0,20.0,5.6,4.4,drizzle
      2013-03-31,0.0,20.6,6.7,2.9,sun
      2013-04-01,0.0,17.2,8.3,3.6,sun
      2013-04-02,0.0,13.9,8.9,2.2,sun
      2013-04-03,0.0,16.7,7.8,1.6,sun
      2013-04-04,8.4,14.4,10.0,3.0,rain
      2013-04-05,18.5,13.9,10.0,5.6,rain
      2013-04-06,12.7,12.2,7.2,5.0,rain
      2013-04-07,39.1,8.3,5.0,3.9,rain
      2013-04-08,0.8,13.3,6.1,3.1,rain
      2013-04-09,0.0,12.2,6.1,2.4,sun
      2013-04-10,9.4,15.0,8.9,6.4,rain
      2013-04-11,1.5,12.2,6.7,3.8,rain
      2013-04-12,9.7,7.8,4.4,4.6,rain
      2013-04-13,9.4,10.6,3.3,5.7,rain
      2013-04-14,5.8,12.8,4.4,2.3,rain
      2013-04-15,0.0,13.9,4.4,2.4,fog
      2013-04-16,0.3,13.9,3.3,2.6,rain
      2013-04-17,0.0,15.0,3.9,3.3,drizzle
      2013-04-18,5.3,11.7,6.7,4.0,rain
      2013-04-19,20.6,13.3,9.4,4.9,rain
      2013-04-20,0.0,13.9,8.3,5.8,sun
      2013-04-21,3.3,12.2,6.7,4.1,rain
      2013-04-22,0.0,16.1,5.0,4.3,sun
      2013-04-23,0.0,17.8,3.9,2.8,sun
      2013-04-24,0.0,21.1,6.1,3.0,sun
      2013-04-25,0.0,21.7,6.7,1.1,sun
      2013-04-26,0.0,20.6,8.3,2.2,fog
      2013-04-27,0.0,13.9,10.6,5.9,sun
      2013-04-28,1.0,15.0,9.4,5.2,rain
      2013-04-29,3.8,13.9,6.7,4.2,rain
      2013-04-30,0.0,12.8,4.4,2.4,sun
      2013-05-01,0.0,18.3,3.3,3.1,sun
      2013-05-02,0.0,20.6,6.7,4.0,sun
      2013-05-03,0.0,21.7,9.4,4.9,sun
      2013-05-04,0.0,25.0,11.1,6.5,sun
      2013-05-05,0.0,28.9,11.7,5.3,sun
      2013-05-06,0.0,30.6,12.2,2.0,sun
      2013-05-07,0.0,20.6,11.1,3.3,sun
      2013-05-08,0.0,19.4,11.1,1.9,sun
      2013-05-09,0.0,22.8,10.0,1.3,sun
      2013-05-10,0.0,26.1,9.4,1.0,sun
      2013-05-11,0.0,27.2,12.2,2.6,sun
      2013-05-12,6.6,21.7,13.9,3.9,rain
      2013-05-13,3.3,18.9,9.4,5.0,rain
      2013-05-14,0.0,18.3,7.8,2.4,sun
      2013-05-15,1.0,17.2,8.9,2.3,rain
      2013-05-16,0.0,21.7,12.2,2.7,fog
      2013-05-17,0.5,17.2,11.7,3.7,rain
      2013-05-18,0.0,16.7,11.1,2.9,sun
      2013-05-19,0.0,18.3,10.6,2.3,sun
      2013-05-20,0.0,19.4,9.4,1.8,sun
      2013-05-21,13.7,15.6,8.3,4.8,rain
      2013-05-22,13.7,11.1,7.2,3.0,rain
      2013-05-23,4.1,12.2,6.7,1.9,rain
      2013-05-24,0.3,16.7,8.9,2.7,rain
      2013-05-25,0.0,17.8,10.0,2.7,sun
      2013-05-26,1.5,18.3,10.6,2.2,rain
      2013-05-27,9.7,16.7,11.1,3.1,rain
      2013-05-28,0.5,17.2,11.7,2.8,rain
      2013-05-29,5.6,16.1,9.4,4.0,rain
      2013-05-30,0.0,16.7,9.4,5.3,sun
      2013-05-31,0.0,19.4,11.1,2.5,sun
      2013-06-01,0.0,22.8,12.2,2.5,sun
      2013-06-02,1.0,20.6,12.2,3.1,rain
      2013-06-03,0.0,22.2,11.1,2.9,sun
      2013-06-04,0.0,26.1,12.2,3.4,sun
      2013-06-05,0.0,26.7,14.4,3.1,sun
      2013-06-06,0.0,26.7,12.2,2.5,sun
      2013-06-07,0.0,21.7,13.3,3.2,sun
      2013-06-08,0.0,20.6,12.8,3.1,sun
      2013-06-09,0.0,20.6,11.1,3.7,sun
      2013-06-10,0.0,21.7,11.7,3.2,sun
      2013-06-11,0.0,20.0,10.0,5.7,sun
      2013-06-12,0.3,20.6,11.7,4.2,rain
      2013-06-13,0.0,21.1,11.7,2.6,sun
      2013-06-14,0.0,20.0,12.2,3.7,sun
      2013-06-15,0.0,25.6,10.0,2.9,sun
      2013-06-16,0.0,23.9,12.8,3.4,sun
      2013-06-17,0.0,25.6,13.9,3.0,sun
      2013-06-18,0.3,23.3,13.3,3.4,rain
      2013-06-19,0.0,20.0,12.8,3.7,sun
      2013-06-20,3.0,17.2,12.8,5.0,rain
      2013-06-21,0.3,20.6,12.2,1.5,rain
      2013-06-22,0.0,25.6,11.7,1.7,sun
      2013-06-23,7.9,22.2,15.0,2.1,rain
      2013-06-24,4.8,21.1,13.9,3.7,rain
      2013-06-25,9.9,23.3,14.4,2.8,rain
      2013-06-26,2.0,22.2,15.0,2.3,rain
      2013-06-27,3.6,21.1,16.7,1.3,rain
      2013-06-28,0.0,30.6,16.1,2.2,sun
      2013-06-29,0.0,30.0,18.3,1.7,sun
      2013-06-30,0.0,33.9,17.2,2.5,sun
      2013-07-01,0.0,31.7,18.3,2.3,sun
      2013-07-02,0.0,28.3,15.6,3.0,sun
      2013-07-03,0.0,26.1,16.7,3.2,sun
      2013-07-04,0.0,21.7,13.9,2.2,fog
      2013-07-05,0.0,23.3,13.9,2.6,sun
      2013-07-06,0.0,26.1,13.3,2.2,sun
      2013-07-07,0.0,23.9,13.9,2.9,sun
      2013-07-08,0.0,26.7,13.3,2.8,sun
      2013-07-09,0.0,30.0,15.0,2.5,sun
      2013-07-10,0.0,22.2,13.9,2.6,sun
      2013-07-11,0.0,22.8,12.2,3.0,sun
      2013-07-12,0.0,19.4,13.3,2.2,sun
      2013-07-13,0.0,26.1,11.1,3.1,sun
      2013-07-14,0.0,27.8,12.8,3.0,sun
      2013-07-15,0.0,27.8,14.4,4.6,sun
      2013-07-16,0.0,31.1,18.3,4.1,sun
      2013-07-17,0.0,22.2,15.0,3.7,sun
      2013-07-18,0.0,26.1,13.9,2.0,sun
      2013-07-19,0.0,27.8,13.3,1.9,sun
      2013-07-20,0.0,25.0,13.3,2.0,sun
      2013-07-21,0.0,23.9,12.8,2.3,sun
      2013-07-22,0.0,26.1,13.3,2.4,fog
      2013-07-23,0.0,31.1,13.9,3.0,sun
      2013-07-24,0.0,31.1,14.4,2.5,sun
      2013-07-25,0.0,31.1,12.8,2.3,sun
      2013-07-26,0.0,31.1,14.4,2.9,sun
      2013-07-27,0.0,25.6,12.8,2.6,sun
      2013-07-28,0.0,21.1,12.2,3.4,fog
      2013-07-29,0.0,25.0,13.3,1.4,sun
      2013-07-30,0.0,25.0,13.3,2.8,sun
      2013-07-31,0.0,21.7,13.3,1.8,sun
      2013-08-01,0.0,20.6,13.3,3.9,sun
      2013-08-02,2.0,17.2,15.0,2.0,rain
      2013-08-03,0.0,25.0,15.6,2.4,fog
      2013-08-04,0.0,28.9,15.0,3.4,sun
      2013-08-05,0.0,30.0,15.0,2.1,sun
      2013-08-06,0.0,30.6,13.9,1.4,sun
      2013-08-07,0.0,31.1,13.9,1.9,sun
      2013-08-08,0.0,28.3,14.4,2.5,sun
      2013-08-09,0.0,28.3,14.4,2.1,sun
      2013-08-10,2.3,25.6,15.0,2.9,rain
      2013-08-11,0.0,25.0,14.4,2.9,sun
      2013-08-12,0.0,25.6,16.1,1.9,sun
      2013-08-13,0.0,27.8,15.0,1.8,sun
      2013-08-14,0.8,27.2,15.0,2.0,rain
      2013-08-15,1.8,21.1,17.2,1.0,rain
      2013-08-16,0.0,28.9,16.1,2.2,fog
      2013-08-17,0.0,25.6,17.2,3.0,sun
      2013-08-18,0.0,26.1,15.6,3.1,sun
      2013-08-19,0.0,26.7,15.6,3.0,sun
      2013-08-20,0.0,25.6,16.1,4.6,sun
      2013-08-21,0.0,27.8,15.0,4.3,sun
      2013-08-22,0.0,28.9,15.0,1.9,sun
      2013-08-23,0.0,25.0,16.1,4.1,sun
      2013-08-24,0.0,25.0,16.7,2.7,sun
      2013-08-25,0.3,22.2,16.1,2.6,rain
      2013-08-26,1.0,24.4,16.1,1.9,rain
      2013-08-27,1.3,26.7,17.2,1.4,rain
      2013-08-28,5.6,26.7,15.6,1.3,rain
      2013-08-29,19.3,23.9,18.3,3.0,rain
      2013-08-30,0.0,26.1,16.1,2.9,sun
      2013-08-31,0.0,27.8,13.9,2.6,sun
      2013-09-01,0.0,27.8,15.6,2.5,sun
      2013-09-02,0.0,27.8,17.2,2.1,sun
      2013-09-03,2.3,25.0,16.7,1.7,rain
      2013-09-04,0.3,22.8,16.1,2.4,rain
      2013-09-05,27.7,20.0,15.6,2.5,rain
      2013-09-06,21.3,21.7,16.1,2.6,rain
      2013-09-07,0.0,23.3,17.2,2.0,sun
      2013-09-08,0.0,26.7,14.4,1.5,fog
      2013-09-09,0.0,26.1,13.9,2.1,sun
      2013-09-10,0.0,26.7,15.0,3.7,sun
      2013-09-11,0.0,33.9,16.1,2.4,sun
      2013-09-12,0.0,25.6,15.0,1.7,sun
      2013-09-13,0.0,18.9,15.6,2.0,sun
      2013-09-14,0.0,21.7,15.6,1.4,fog
      2013-09-15,3.3,18.9,14.4,2.2,rain
      2013-09-16,0.3,21.7,15.0,4.3,rain
      2013-09-17,0.0,17.8,13.9,2.3,sun
      2013-09-18,0.0,21.1,13.3,2.5,sun
      2013-09-19,0.0,25.6,10.0,1.5,sun
      2013-09-20,3.6,23.3,13.3,3.0,rain
      2013-09-21,0.0,21.1,13.3,2.5,sun
      2013-09-22,13.5,17.2,13.3,5.5,rain
      2013-09-23,2.8,16.1,11.1,4.5,rain
      2013-09-24,0.0,17.8,10.0,2.6,sun
      2013-09-25,2.0,16.1,9.4,3.0,rain
      2013-09-26,0.0,17.2,7.2,2.2,sun
      2013-09-27,1.0,13.9,10.6,4.3,rain
      2013-09-28,43.4,16.7,11.7,6.0,rain
      2013-09-29,16.8,14.4,11.1,7.1,rain
      2013-09-30,18.5,13.9,10.0,6.3,rain
      2013-10-01,7.9,14.4,8.9,4.7,rain
      2013-10-02,5.3,12.8,9.4,2.4,rain
      2013-10-03,0.8,14.4,8.9,0.9,rain
      2013-10-04,0.0,17.8,5.6,1.1,sun
      2013-10-05,0.0,20.0,8.3,1.6,sun
      2013-10-06,4.1,22.8,7.8,2.6,rain
      2013-10-07,0.5,16.1,11.7,6.3,rain
      2013-10-08,6.9,13.9,7.8,3.0,rain
      2013-10-09,0.0,15.0,5.6,1.6,sun
      2013-10-10,1.0,14.4,8.3,1.7,rain
      2013-10-11,9.1,13.9,10.6,1.0,rain
      2013-10-12,1.0,14.4,8.9,2.2,rain
      2013-10-13,0.0,15.0,6.7,1.8,fog
      2013-10-14,0.0,15.6,3.9,1.6,sun
      2013-10-15,0.0,15.6,5.0,0.9,sun
      2013-10-16,0.0,12.8,8.9,2.7,fog
      2013-10-17,0.0,14.4,8.9,1.7,fog
      2013-10-18,0.0,12.8,7.2,1.2,sun
      2013-10-19,0.0,10.6,7.8,1.4,sun
      2013-10-20,0.0,10.6,7.8,2.4,sun
      2013-10-21,0.0,11.7,8.3,2.5,sun
      2013-10-22,0.0,14.4,7.2,1.9,sun
      2013-10-23,0.0,12.8,6.1,0.4,sun
      2013-10-24,0.0,10.0,6.1,0.6,sun
      2013-10-25,0.0,12.2,7.8,1.8,sun
      2013-10-26,0.0,11.7,8.3,2.7,sun
      2013-10-27,1.8,13.9,8.3,4.4,rain
      2013-10-28,0.0,14.4,7.2,5.1,sun
      2013-10-29,0.0,13.3,3.3,2.2,sun
      2013-10-30,0.5,15.0,5.6,3.9,rain
      2013-10-31,0.3,14.4,10.6,2.2,rain
      2013-11-01,1.3,17.8,11.7,1.4,rain
      2013-11-02,12.7,14.4,8.3,7.9,rain
      2013-11-03,0.5,12.2,4.4,2.4,rain
      2013-11-04,0.0,10.6,3.9,1.6,drizzle
      2013-11-05,2.5,13.3,7.2,3.1,rain
      2013-11-06,3.8,12.8,7.8,1.7,rain
      2013-11-07,30.0,11.1,10.0,7.2,rain
      2013-11-08,0.0,13.3,7.2,4.1,sun
      2013-11-09,1.8,11.1,5.0,1.4,rain
      2013-11-10,0.0,11.1,8.3,4.4,sun
      2013-11-11,0.0,16.1,6.1,2.6,fog
      2013-11-12,4.1,15.6,8.9,2.2,rain
      2013-11-13,0.0,13.9,10.6,3.8,sun
      2013-11-14,1.3,11.1,6.1,1.1,rain
      2013-11-15,3.0,10.6,7.2,6.0,rain
      2013-11-16,0.0,10.0,5.0,4.6,sun
      2013-11-17,5.3,11.7,7.2,5.4,rain
      2013-11-18,26.2,12.8,9.4,3.9,rain
      2013-11-19,1.0,13.3,4.4,5.1,rain
      2013-11-20,0.0,7.8,1.7,4.3,sun
      2013-11-21,0.0,7.8,-0.5,3.6,sun
      2013-11-22,0.0,9.4,0.0,4.6,sun
      2013-11-23,0.0,11.1,1.1,2.6,sun
      2013-11-24,0.0,11.7,0.6,0.9,fog
      2013-11-25,0.0,12.2,2.2,0.5,sun
      2013-11-26,0.0,12.2,2.8,1.0,sun
      2013-11-27,0.0,14.4,5.6,1.3,sun
      2013-11-28,0.0,11.7,3.3,0.7,sun
      2013-11-29,0.5,9.4,5.0,2.1,rain
      2013-11-30,2.3,11.1,7.2,3.9,rain
      2013-12-01,3.0,13.3,7.8,8.8,rain
      2013-12-02,4.6,7.8,1.7,3.5,rain
      2013-12-03,0.0,5.0,-0.5,5.6,sun
      2013-12-04,0.0,4.4,-2.1,1.6,sun
      2013-12-05,0.0,1.1,-4.9,2.6,sun
      2013-12-06,0.0,1.1,-4.3,4.7,sun
      2013-12-07,0.0,0.0,-7.1,3.1,sun
      2013-12-08,0.0,2.2,-6.6,2.2,sun
      2013-12-09,0.0,1.1,-4.9,1.3,sun
      2013-12-10,0.0,5.6,0.6,1.5,sun
      2013-12-11,0.0,5.0,-1.6,0.8,sun
      2013-12-12,6.9,5.6,-0.5,2.3,rain
      2013-12-13,0.5,9.4,5.6,2.9,rain
      2013-12-14,0.0,9.4,6.1,3.7,sun
      2013-12-15,1.3,11.7,8.3,3.9,rain
      2013-12-16,0.3,10.0,4.4,1.0,rain
      2013-12-17,0.0,8.3,4.4,2.7,sun
      2013-12-18,1.3,7.8,2.2,2.8,rain
      2013-12-19,0.0,5.0,0.0,2.1,sun
      2013-12-20,5.6,8.3,0.6,3.7,snow
      2013-12-21,5.6,8.9,5.6,2.3,rain
      2013-12-22,10.7,10.6,8.3,4.0,rain
      2013-12-23,1.5,11.7,6.1,5.9,rain
      2013-12-24,0.0,8.3,2.8,1.7,sun
      2013-12-25,0.0,6.7,1.7,0.8,sun
      2013-12-26,0.0,6.7,0.6,0.5,sun
      2013-12-27,0.3,8.9,0.0,2.1,rain
      2013-12-28,0.0,9.4,3.3,1.3,sun
      2013-12-29,0.0,7.2,1.7,1.1,sun
      2013-12-30,0.3,8.9,4.4,2.6,rain
      2013-12-31,0.5,8.3,5.0,1.7,rain
      2014-01-01,0.0,7.2,3.3,1.2,sun
      2014-01-02,4.1,10.6,6.1,3.2,rain
      2014-01-03,1.5,8.9,2.8,2.6,rain
      2014-01-04,0.0,7.8,0.6,2.7,fog
      2014-01-05,0.0,8.3,-0.5,3.7,sun
      2014-01-06,0.3,7.8,-0.5,2.6,rain
      2014-01-07,12.2,8.3,5.0,1.6,rain
      2014-01-08,9.7,10.0,7.2,4.6,rain
      2014-01-09,5.8,9.4,5.6,6.3,rain
      2014-01-10,4.3,12.8,8.3,7.0,rain
      2014-01-11,21.3,14.4,7.2,8.8,rain
      2014-01-12,1.5,11.1,5.6,8.1,rain
      2014-01-13,0.0,10.6,10.0,7.1,sun
      2014-01-14,0.0,11.1,7.2,1.3,sun
      2014-01-15,0.0,11.1,5.6,2.5,sun
      2014-01-16,0.0,6.7,4.4,2.7,sun
      2014-01-17,0.0,5.6,2.8,2.3,sun
      2014-01-18,0.0,9.4,0.6,2.2,sun
      2014-01-19,0.0,6.1,3.3,2.5,sun
      2014-01-20,0.0,10.0,2.8,2.2,sun
      2014-01-21,0.0,10.0,1.7,1.5,sun
      2014-01-22,0.5,9.4,5.6,2.6,rain
      2014-01-23,0.0,10.0,2.8,5.2,fog
      2014-01-24,0.0,12.8,1.1,1.9,sun
      2014-01-25,0.0,12.2,1.1,0.8,sun
      2014-01-26,0.0,8.3,0.6,1.3,sun
      2014-01-27,0.0,9.4,1.7,1.3,sun
      2014-01-28,8.9,11.1,6.1,1.6,rain
      2014-01-29,21.6,11.1,7.2,3.4,rain
      2014-01-30,0.0,8.3,6.1,6.4,sun
      2014-01-31,2.3,7.8,5.6,2.6,rain
      2014-02-01,2.0,7.8,2.8,0.8,rain
      2014-02-02,0.0,8.9,1.1,2.5,sun
      2014-02-03,0.0,5.0,0.0,4.3,sun
      2014-02-04,0.0,2.8,-2.1,4.7,sun
      2014-02-05,0.0,-0.5,-5.5,6.6,sun
      2014-02-06,0.0,-1.6,-6.0,4.5,sun
      2014-02-07,0.0,3.3,-4.9,4.2,sun
      2014-02-08,5.1,5.6,-0.5,4.6,snow
      2014-02-09,0.5,3.9,0.0,2.4,rain
      2014-02-10,18.3,10.0,2.2,4.7,rain
      2014-02-11,17.0,12.2,5.6,3.8,rain
      2014-02-12,4.6,12.2,7.2,6.4,rain
      2014-02-13,1.8,12.8,7.8,6.3,rain
      2014-02-14,9.4,11.7,6.1,6.4,rain
      2014-02-15,11.7,11.1,5.0,5.1,rain
      2014-02-16,26.4,9.4,3.9,7.9,rain
      2014-02-17,14.5,8.3,4.4,5.5,rain
      2014-02-18,15.2,8.9,5.0,6.2,rain
      2014-02-19,1.0,8.3,3.9,6.0,rain
      2014-02-20,3.0,10.0,5.6,6.9,rain
      2014-02-21,2.8,6.7,3.9,2.9,rain
      2014-02-22,2.5,5.6,2.8,3.1,rain
      2014-02-23,6.1,7.2,3.9,2.6,rain
      2014-02-24,13.0,6.7,3.3,3.2,rain
      2014-02-25,0.3,12.2,3.9,4.5,rain
      2014-02-26,0.0,13.9,5.6,2.5,sun
      2014-02-27,0.0,12.8,4.4,2.3,sun
      2014-02-28,0.0,14.4,4.4,5.9,sun
      2014-03-01,0.5,7.2,4.4,4.7,rain
      2014-03-02,19.1,11.1,2.8,5.7,rain
      2014-03-03,10.7,14.4,8.9,5.1,rain
      2014-03-04,16.5,13.9,7.8,3.9,rain
      2014-03-05,46.7,15.6,10.6,3.9,rain
      2014-03-06,3.0,13.3,10.0,6.2,rain
      2014-03-07,0.0,15.6,8.9,4.2,sun
      2014-03-08,32.3,12.8,6.7,2.7,rain
      2014-03-09,4.3,15.0,9.4,4.3,rain
      2014-03-10,18.8,12.2,6.1,2.2,rain
      2014-03-11,0.0,14.4,4.4,2.3,fog
      2014-03-12,0.0,16.1,3.3,1.9,fog
      2014-03-13,0.5,13.9,5.0,2.5,rain
      2014-03-14,6.9,14.4,8.3,6.1,rain
      2014-03-15,8.1,16.7,4.4,3.0,rain
      2014-03-16,27.7,10.6,4.4,3.8,rain
      2014-03-17,0.3,10.0,2.8,3.2,rain
      2014-03-18,0.0,10.0,3.3,1.6,sun
      2014-03-19,0.5,11.1,3.3,5.1,rain
      2014-03-20,0.0,11.1,1.7,3.0,sun
      2014-03-21,0.0,10.6,2.8,3.8,sun
      2014-03-22,0.0,11.1,1.1,1.8,sun
      2014-03-23,0.0,12.8,4.4,3.3,sun
      2014-03-24,0.0,18.9,2.8,2.2,sun
      2014-03-25,4.1,13.9,6.7,4.4,rain
      2014-03-26,3.6,11.1,5.6,2.4,rain
      2014-03-27,0.3,12.2,6.7,2.8,rain
      2014-03-28,22.1,11.7,7.2,3.9,rain
      2014-03-29,14.0,11.7,7.2,5.1,rain
      2014-03-30,0.0,11.1,5.0,5.1,sun
      2014-03-31,0.0,15.6,2.2,3.8,sun
      2014-04-01,0.0,14.4,6.7,2.8,sun
      2014-04-02,0.0,14.4,5.6,4.2,sun
      2014-04-03,2.5,13.3,6.1,3.9,rain
      2014-04-04,0.0,12.8,6.1,4.7,sun
      2014-04-05,4.6,11.7,7.8,4.3,rain
      2014-04-06,0.0,13.9,8.3,2.6,sun
      2014-04-07,0.0,21.1,9.4,2.5,sun
      2014-04-08,4.6,15.6,8.3,4.2,rain
      2014-04-09,0.0,14.4,6.7,2.9,sun
      2014-04-10,0.0,15.0,6.7,3.6,sun
      2014-04-11,0.0,17.2,5.0,2.8,sun
      2014-04-12,0.0,16.1,7.8,4.4,sun
      2014-04-13,0.0,20.6,5.6,3.1,sun
      2014-04-14,0.0,20.0,5.6,2.6,sun
      2014-04-15,0.5,14.4,7.8,4.0,rain
      2014-04-16,10.9,11.1,8.9,4.6,rain
      2014-04-17,18.5,11.7,7.2,4.7,rain
      2014-04-18,0.0,14.4,5.6,3.8,sun
      2014-04-19,13.7,11.7,5.6,4.7,rain
      2014-04-20,0.0,15.6,5.6,2.7,sun
      2014-04-21,5.1,17.2,7.8,2.5,rain
      2014-04-22,14.2,12.2,5.0,4.2,rain
      2014-04-23,8.9,11.7,6.1,5.0,rain
      2014-04-24,12.4,13.9,6.1,5.3,rain
      2014-04-25,0.0,14.4,5.6,2.3,sun
      2014-04-26,3.3,15.0,5.6,3.9,rain
      2014-04-27,6.9,11.1,6.1,5.8,rain
      2014-04-28,0.0,16.1,4.4,2.6,sun
      2014-04-29,0.0,25.0,9.4,2.3,sun
      2014-04-30,0.0,27.8,9.4,3.9,sun
      2014-05-01,0.0,29.4,11.1,3.0,sun
      2014-05-02,0.0,18.3,10.6,4.7,sun
      2014-05-03,33.3,15.0,8.9,3.4,rain
      2014-05-04,16.0,14.4,8.9,4.2,rain
      2014-05-05,5.1,15.6,9.4,3.8,rain
      2014-05-06,0.0,16.7,8.3,2.6,sun
      2014-05-07,0.0,18.3,7.2,1.7,sun
      2014-05-08,13.7,13.9,9.4,3.4,rain
      2014-05-09,2.0,13.3,7.2,5.6,rain
      2014-05-10,0.5,15.6,7.2,2.1,rain
      2014-05-11,0.0,18.9,8.3,1.7,sun
      2014-05-12,0.0,24.4,9.4,2.7,sun
      2014-05-13,0.0,26.7,12.8,3.8,sun
      2014-05-14,0.0,27.8,13.3,3.3,sun
      2014-05-15,0.0,26.7,12.8,3.0,sun
      2014-05-16,0.0,20.0,11.7,4.1,sun
      2014-05-17,0.0,20.0,11.7,3.2,sun
      2014-05-18,0.0,20.0,10.6,3.2,sun
      2014-05-19,0.0,21.1,10.0,2.2,sun
      2014-05-20,0.0,22.2,10.0,2.7,sun
      2014-05-21,0.0,20.0,10.6,1.7,sun
      2014-05-22,0.0,24.4,11.7,2.5,sun
      2014-05-23,3.8,20.0,12.8,4.0,rain
      2014-05-24,0.0,18.3,11.1,2.4,sun
      2014-05-25,5.6,15.0,10.6,1.4,rain
      2014-05-26,0.0,18.3,11.1,4.5,sun
      2014-05-27,0.0,20.0,10.0,2.5,sun
      2014-05-28,0.0,18.9,10.0,3.4,sun
      2014-05-29,0.0,18.9,11.1,4.3,sun
      2014-05-30,0.0,20.6,8.9,4.5,sun
      2014-05-31,0.0,23.3,10.0,2.2,sun
      2014-06-01,0.0,22.2,10.6,2.3,sun
      2014-06-02,0.0,23.3,11.1,2.4,sun
      2014-06-03,0.0,18.3,11.1,3.2,sun
      2014-06-04,0.0,19.4,10.0,2.6,sun
      2014-06-05,0.0,22.2,10.0,2.4,sun
      2014-06-06,0.0,25.0,10.6,3.2,sun
      2014-06-07,0.0,24.4,13.3,3.1,sun
      2014-06-08,0.0,23.3,12.2,2.1,sun
      2014-06-09,0.0,21.1,13.3,3.6,sun
      2014-06-10,0.0,20.0,12.2,2.9,sun
      2014-06-11,0.0,23.9,11.1,2.7,sun
      2014-06-12,1.8,21.7,12.2,4.0,rain
      2014-06-13,6.4,15.6,11.1,5.0,rain
      2014-06-14,0.0,17.8,11.7,3.2,sun
      2014-06-15,0.5,18.3,10.0,3.6,rain
      2014-06-16,3.6,17.8,8.9,2.4,rain
      2014-06-17,1.3,17.8,10.0,3.0,rain
      2014-06-18,0.0,18.9,11.1,2.7,sun
      2014-06-19,0.8,25.6,11.7,3.7,rain
      2014-06-20,0.3,20.0,10.0,3.4,rain
      2014-06-21,0.0,22.2,10.6,3.6,sun
      2014-06-22,0.0,25.0,11.1,2.7,sun
      2014-06-23,0.0,25.0,13.3,2.5,sun
      2014-06-24,0.0,24.4,14.4,2.5,sun
      2014-06-25,0.0,26.1,13.9,2.4,sun
      2014-06-26,0.0,21.1,14.4,4.1,sun
      2014-06-27,1.8,21.1,13.9,4.5,rain
      2014-06-28,2.3,20.0,13.3,4.3,rain
      2014-06-29,0.0,20.6,12.8,3.2,sun
      2014-06-30,0.0,25.6,12.8,4.4,sun
      2014-07-01,0.0,34.4,15.6,3.5,sun
      2014-07-02,0.0,27.2,14.4,3.6,sun
      2014-07-03,0.0,21.7,13.9,3.1,sun
      2014-07-04,0.0,23.9,13.9,3.6,sun
      2014-07-05,0.0,24.4,13.3,2.2,fog
      2014-07-06,0.0,28.9,15.0,3.0,sun
      2014-07-07,0.0,27.2,17.8,4.1,fog
      2014-07-08,0.0,30.0,15.6,3.5,sun
      2014-07-09,0.0,26.7,13.9,2.3,sun
      2014-07-10,0.0,28.9,12.8,2.2,fog
      2014-07-11,0.0,31.1,15.0,2.2,sun
      2014-07-12,0.0,32.2,16.7,2.2,sun
      2014-07-13,0.0,29.4,15.0,2.6,sun
      2014-07-14,0.0,27.8,15.0,2.8,sun
      2014-07-15,0.0,31.1,13.9,2.3,sun
      2014-07-16,0.0,31.1,14.4,2.4,sun
      2014-07-17,0.0,26.7,13.9,3.7,sun
      2014-07-18,0.0,23.9,11.7,2.8,sun
      2014-07-19,0.0,25.6,15.0,5.4,fog
      2014-07-20,0.0,19.4,14.4,2.8,sun
      2014-07-21,0.0,23.9,13.3,2.2,sun
      2014-07-22,0.3,21.1,13.3,1.1,rain
      2014-07-23,19.3,18.9,13.3,3.3,rain
      2014-07-24,0.0,20.6,12.8,4.7,sun
      2014-07-25,0.0,22.8,12.2,2.7,sun
      2014-07-26,0.0,26.1,13.3,3.6,sun
      2014-07-27,0.0,28.3,15.0,4.1,sun
      2014-07-28,0.0,30.6,15.0,3.7,sun
      2014-07-29,0.0,30.0,15.6,2.8,sun
      2014-07-30,0.0,29.4,14.4,3.4,sun
      2014-07-31,0.0,30.6,17.8,4.1,sun
      2014-08-01,0.0,28.9,15.0,3.3,sun
      2014-08-02,0.5,29.4,15.6,1.7,rain
      2014-08-03,0.0,31.7,14.4,2.6,sun
      2014-08-04,0.0,32.8,16.1,2.6,sun
      2014-08-05,0.0,25.0,13.9,2.7,sun
      2014-08-06,0.0,26.1,15.0,2.2,fog
      2014-08-07,0.0,25.6,13.3,2.4,fog
      2014-08-08,0.0,25.6,13.3,2.9,sun
      2014-08-09,0.0,27.2,15.6,4.1,sun
      2014-08-10,0.0,30.6,13.9,3.4,sun
      2014-08-11,0.5,35.6,17.8,2.6,rain
      2014-08-12,12.7,27.2,17.2,3.1,rain
      2014-08-13,21.6,23.3,15.0,2.7,rain
      2014-08-14,0.0,21.1,17.2,0.6,sun
      2014-08-15,1.0,24.4,16.7,1.5,rain
      2014-08-16,0.0,25.6,15.6,2.2,sun
      2014-08-17,0.0,27.8,15.0,2.8,sun
      2014-08-18,0.0,29.4,15.6,3.3,sun
      2014-08-19,0.0,27.2,15.6,2.4,sun
      2014-08-20,0.0,21.7,13.9,3.6,sun
      2014-08-21,0.0,21.1,11.1,1.7,sun
      2014-08-22,0.0,23.9,13.3,2.9,sun
      2014-08-23,0.0,27.8,13.9,2.0,sun
      2014-08-24,0.0,25.0,13.3,2.3,sun
      2014-08-25,0.0,28.9,14.4,2.0,sun
      2014-08-26,0.0,31.1,15.6,1.8,sun
      2014-08-27,0.0,28.9,16.1,1.6,sun
      2014-08-28,0.0,23.3,14.4,2.3,sun
      2014-08-29,0.0,22.8,15.0,3.4,sun
      2014-08-30,8.4,17.8,15.0,2.2,rain
      2014-08-31,1.3,21.1,13.9,1.9,rain
      2014-09-01,0.0,23.3,12.8,2.5,sun
      2014-09-02,3.0,20.0,13.9,4.3,rain
      2014-09-03,0.0,20.6,12.8,2.7,sun
      2014-09-04,0.0,23.9,11.1,3.1,fog
      2014-09-05,0.0,27.8,13.9,6.5,fog
      2014-09-06,0.0,32.2,15.0,2.9,sun
      2014-09-07,0.0,28.3,13.3,2.1,sun
      2014-09-08,0.0,21.1,13.3,2.8,sun
      2014-09-09,0.0,21.7,13.3,2.3,sun
      2014-09-10,0.0,22.2,12.2,3.9,sun
      2014-09-11,0.0,24.4,12.8,5.3,sun
      2014-09-12,0.0,24.4,12.8,5.9,sun
      2014-09-13,0.0,28.3,10.0,4.2,sun
      2014-09-14,0.0,30.0,11.7,1.8,sun
      2014-09-15,0.0,30.6,12.2,1.2,sun
      2014-09-16,0.0,22.2,13.9,2.8,sun
      2014-09-17,0.5,22.8,14.4,2.3,rain
      2014-09-18,0.3,19.4,15.0,3.1,rain
      2014-09-19,0.0,23.9,16.1,2.8,sun
      2014-09-20,0.0,24.4,14.4,4.4,fog
      2014-09-21,0.0,26.1,12.8,3.0,sun
      2014-09-22,0.3,22.2,15.0,2.1,rain
      2014-09-23,18.3,18.9,14.4,2.5,rain
      2014-09-24,20.3,18.9,14.4,2.7,rain
      2014-09-25,4.3,21.7,14.4,2.5,rain
      2014-09-26,8.9,20.0,13.9,3.3,rain
      2014-09-27,0.0,20.6,11.7,3.2,fog
      2014-09-28,0.0,18.9,12.2,2.0,fog
      2014-09-29,0.8,16.7,11.1,3.5,rain
      2014-09-30,0.0,19.4,12.2,2.6,sun
      2014-10-01,0.0,18.3,11.1,2.1,sun
      2014-10-02,0.0,19.4,10.0,2.0,sun
      2014-10-03,0.0,22.2,8.9,1.0,sun
      2014-10-04,0.0,21.7,12.2,1.2,sun
      2014-10-05,0.0,23.9,11.7,1.4,fog
      2014-10-06,0.0,25.6,13.3,2.5,fog
      2014-10-07,0.0,18.9,13.9,1.0,fog
      2014-10-08,0.0,20.6,12.8,1.8,fog
      2014-10-09,0.0,17.2,11.1,1.0,fog
      2014-10-10,0.3,18.3,10.0,3.8,rain
      2014-10-11,7.4,18.3,11.7,3.5,rain
      2014-10-12,0.0,17.8,11.7,2.1,sun
      2014-10-13,7.6,21.1,10.0,3.1,rain
      2014-10-14,7.1,16.7,11.7,2.2,rain
      2014-10-15,8.6,16.1,11.7,4.7,rain
      2014-10-16,0.0,20.6,11.1,3.3,sun
      2014-10-17,3.3,16.7,11.7,3.0,rain
      2014-10-18,15.0,19.4,13.9,1.9,rain
      2014-10-19,0.0,22.2,12.8,3.2,sun
      2014-10-20,11.7,16.1,12.2,3.1,rain
      2014-10-21,1.0,16.1,11.7,4.7,rain
      2014-10-22,32.0,15.6,11.7,5.0,rain
      2014-10-23,9.4,14.4,8.3,4.6,rain
      2014-10-24,4.1,14.4,8.9,3.2,rain
      2014-10-25,6.1,16.7,8.3,5.4,rain
      2014-10-26,1.5,12.8,7.8,5.0,rain
      2014-10-27,0.8,15.6,6.7,2.4,rain
      2014-10-28,12.7,15.0,9.4,3.9,rain
      2014-10-29,0.5,16.7,11.7,3.1,rain
      2014-10-30,25.4,15.6,11.1,3.2,rain
      2014-10-31,17.0,12.8,8.3,2.0,rain
      2014-11-01,0.0,11.1,7.2,1.2,fog
      2014-11-02,1.8,13.3,7.2,2.9,rain
      2014-11-03,10.9,13.9,11.1,4.8,rain
      2014-11-04,4.1,14.4,10.6,3.3,rain
      2014-11-05,4.8,15.0,10.6,2.1,rain
      2014-11-06,4.1,16.7,10.6,6.7,rain
      2014-11-07,0.0,14.4,7.2,2.3,sun
      2014-11-08,0.0,12.8,3.9,0.8,fog
      2014-11-09,5.1,13.3,7.8,3.0,rain
      2014-11-10,0.0,11.1,5.6,3.9,sun
      2014-11-11,0.0,7.8,1.1,7.7,sun
      2014-11-12,0.0,6.7,0.0,7.6,sun
      2014-11-13,0.0,7.2,0.6,4.7,sun
      2014-11-14,0.0,7.2,-2.1,4.5,sun
      2014-11-15,0.0,8.3,-1.6,4.2,sun
      2014-11-16,0.0,9.4,-2.1,4.2,sun
      2014-11-17,0.0,10.6,-2.1,1.9,sun
      2014-11-18,0.0,7.2,-0.5,0.9,sun
      2014-11-19,0.0,11.1,2.2,1.9,sun
      2014-11-20,3.6,11.1,5.6,2.1,rain
      2014-11-21,15.2,11.1,8.3,4.7,rain
      2014-11-22,0.5,9.4,6.7,4.7,rain
      2014-11-23,11.9,12.8,5.6,5.1,rain
      2014-11-24,1.3,11.7,4.4,3.8,rain
      2014-11-25,18.3,13.9,9.4,4.5,rain
      2014-11-26,0.3,15.0,12.2,3.9,rain
      2014-11-27,3.3,14.4,11.7,6.6,rain
      2014-11-28,34.3,12.8,3.3,5.8,rain
      2014-11-29,3.6,4.4,-4.3,5.3,snow
      2014-11-30,0.0,2.8,-4.9,4.4,sun
      2014-12-01,0.0,4.4,-3.2,2.2,sun
      2014-12-02,0.0,5.6,-3.2,5.7,fog
      2014-12-03,0.0,10.0,0.0,3.6,sun
      2014-12-04,0.8,8.3,3.9,1.1,rain
      2014-12-05,3.0,12.8,6.7,3.1,rain
      2014-12-06,7.4,11.7,7.8,3.6,rain
      2014-12-07,0.0,14.4,6.1,2.8,sun
      2014-12-08,9.1,14.4,8.9,4.2,rain
      2014-12-09,9.9,16.1,10.6,5.1,rain
      2014-12-10,13.0,18.9,10.0,6.7,rain
      2014-12-11,6.9,14.4,8.3,6.4,rain
      2014-12-12,0.0,11.1,7.2,3.7,sun
      2014-12-13,0.0,10.0,3.9,1.1,fog
      2014-12-14,0.0,12.8,1.7,3.5,fog
      2014-12-15,0.0,12.2,6.7,5.9,sun
      2014-12-16,0.0,10.0,8.3,4.0,sun
      2014-12-17,2.8,8.9,6.1,1.6,rain
      2014-12-18,13.0,9.4,6.7,3.1,rain
      2014-12-19,3.0,11.1,7.2,4.3,rain
      2014-12-20,19.6,12.8,6.7,5.5,rain
      2014-12-21,0.0,12.8,10.0,5.2,sun
      2014-12-22,0.0,10.6,6.1,1.5,sun
      2014-12-23,20.6,12.2,5.0,3.8,rain
      2014-12-24,5.3,7.2,3.9,1.8,rain
      2014-12-25,0.0,7.8,2.8,2.2,fog
      2014-12-26,0.0,5.6,1.7,1.2,fog
      2014-12-27,3.3,9.4,4.4,4.9,rain
      2014-12-28,4.1,6.7,2.8,1.8,rain
      2014-12-29,0.0,6.1,0.6,4.3,fog
      2014-12-30,0.0,3.3,-2.1,3.6,sun
      2014-12-31,0.0,3.3,-2.7,3.0,sun
      2015-01-01,0.0,5.6,-3.2,1.2,sun
      2015-01-02,1.5,5.6,0.0,2.3,rain
      2015-01-03,0.0,5.0,1.7,1.7,fog
      2015-01-04,10.2,10.6,3.3,4.5,rain
      2015-01-05,8.1,12.2,9.4,6.4,rain
      2015-01-06,0.0,12.2,6.1,1.3,fog
      2015-01-07,0.0,7.8,5.6,1.6,fog
      2015-01-08,0.0,7.8,1.7,2.6,fog
      2015-01-09,0.3,10.0,3.3,0.6,rain
      2015-01-10,5.8,7.8,6.1,0.5,rain
      2015-01-11,1.5,9.4,7.2,1.1,rain
      2015-01-12,0.0,11.1,4.4,1.6,fog
      2015-01-13,0.0,9.4,2.8,2.7,fog
      2015-01-14,0.0,6.1,0.6,2.8,fog
      2015-01-15,9.7,7.8,1.1,3.2,rain
      2015-01-16,0.0,11.7,5.6,4.5,fog
      2015-01-17,26.2,13.3,3.3,2.8,rain
      2015-01-18,21.3,13.9,7.2,6.6,rain
      2015-01-19,0.5,10.0,6.1,2.8,rain
      2015-01-20,0.0,10.0,3.3,3.0,fog
      2015-01-21,0.0,7.2,-0.5,1.3,fog
      2015-01-22,0.8,9.4,6.1,1.3,rain
      2015-01-23,5.8,12.2,8.3,2.6,rain
      2015-01-24,0.5,14.4,11.1,3.3,rain
      2015-01-25,0.0,17.2,7.2,1.4,fog
      2015-01-26,0.0,16.1,6.1,2.2,fog
      2015-01-27,0.8,11.1,8.3,2.0,rain
      2015-01-28,0.0,12.2,5.0,1.8,fog
      2015-01-29,0.0,12.2,3.3,2.9,sun
      2015-01-30,0.0,8.3,1.1,0.8,fog
      2015-01-31,0.0,7.2,3.3,1.9,fog
      2015-02-01,1.5,9.4,4.4,2.6,rain
      2015-02-02,7.4,11.1,5.0,4.0,rain
      2015-02-03,1.3,10.0,5.6,1.9,rain
      2015-02-04,8.4,10.6,4.4,1.7,rain
      2015-02-05,26.2,13.3,8.3,4.6,rain
      2015-02-06,17.3,14.4,10.0,4.5,rain
      2015-02-07,23.6,12.2,9.4,4.6,rain
      2015-02-08,3.6,15.0,8.3,3.9,rain
      2015-02-09,6.1,13.3,8.3,2.5,rain
      2015-02-10,0.3,12.8,8.3,4.0,rain
      2015-02-11,0.0,12.8,5.6,1.0,fog
      2015-02-12,1.0,16.7,9.4,2.1,rain
      2015-02-13,0.0,15.6,6.7,1.7,fog
      2015-02-14,0.3,14.4,6.7,2.9,rain
      2015-02-15,0.0,12.2,3.9,4.8,sun
      2015-02-16,0.0,15.0,5.6,6.6,fog
      2015-02-17,0.0,16.1,4.4,4.0,sun
      2015-02-18,0.0,12.2,4.4,2.6,sun
      2015-02-19,4.6,10.6,8.3,2.2,rain
      2015-02-20,0.8,11.1,7.2,0.9,rain
      2015-02-21,0.0,12.2,5.6,4.5,sun
      2015-02-22,0.0,11.7,3.3,4.2,sun
      2015-02-23,0.0,12.8,0.6,1.4,sun
      2015-02-24,0.0,11.1,2.2,1.5,sun
      2015-02-25,4.1,10.0,6.7,1.0,rain
      2015-02-26,9.4,11.7,7.8,1.4,rain
      2015-02-27,18.3,10.0,6.7,4.0,rain
      2015-02-28,0.0,12.2,3.3,5.1,sun
      2015-03-01,0.0,11.1,1.1,2.2,sun
      2015-03-02,0.0,11.1,4.4,4.8,sun
      2015-03-03,0.0,10.6,0.0,2.1,sun
      2015-03-04,0.0,12.8,-0.5,1.8,sun
      2015-03-05,0.0,13.3,2.8,1.3,sun
      2015-03-06,0.0,15.0,3.3,1.4,sun
      2015-03-07,0.0,16.7,3.9,2.7,fog
      2015-03-08,0.0,17.2,3.9,1.7,fog
      2015-03-09,0.0,14.4,4.4,1.8,fog
      2015-03-10,0.8,13.3,5.0,2.6,rain
      2015-03-11,2.5,14.4,8.9,3.1,rain
      2015-03-12,0.0,17.8,9.4,3.2,sun
      2015-03-13,2.0,17.2,7.8,2.2,rain
      2015-03-14,17.0,13.9,9.4,3.8,rain
      2015-03-15,55.9,10.6,6.1,4.2,rain
      2015-03-16,1.0,13.9,6.1,3.0,rain
      2015-03-17,0.8,13.3,4.4,2.6,rain
      2015-03-18,0.0,15.6,7.2,2.5,sun
      2015-03-19,0.0,15.6,8.3,1.9,sun
      2015-03-20,4.1,13.9,8.9,1.9,rain
      2015-03-21,3.8,13.3,8.3,4.7,rain
      2015-03-22,1.0,11.7,6.1,2.3,rain
      2015-03-23,8.1,11.1,5.6,2.8,rain
      2015-03-24,7.6,12.8,6.1,3.9,rain
      2015-03-25,5.1,14.4,7.2,4.4,rain
      2015-03-26,0.0,20.6,10.0,2.2,sun
      2015-03-27,1.0,18.3,8.9,4.0,rain
      2015-03-28,0.0,15.6,9.4,5.7,sun
      2015-03-29,0.0,15.6,8.9,3.0,sun
      2015-03-30,1.8,17.8,10.6,2.9,rain
      2015-03-31,1.0,12.8,6.1,4.2,rain
      2015-04-01,5.1,12.8,5.6,3.2,rain
      2015-04-02,0.0,13.3,5.6,2.4,sun
      2015-04-03,1.5,11.1,5.0,3.6,rain
      2015-04-04,0.0,12.8,3.9,1.7,sun
      2015-04-05,0.0,16.7,2.8,2.4,sun
      2015-04-06,1.0,13.9,6.7,3.5,rain
      2015-04-07,0.5,14.4,6.7,3.9,rain
      2015-04-08,0.0,17.2,6.1,1.7,sun
      2015-04-09,0.0,17.2,6.1,2.3,sun
      2015-04-10,10.9,13.9,7.8,4.6,rain
      2015-04-11,0.0,11.7,5.6,6.5,sun
      2015-04-12,0.0,13.3,5.6,3.6,sun
      2015-04-13,14.0,11.7,3.9,3.6,rain
      2015-04-14,3.3,11.7,2.8,3.3,rain
      2015-04-15,0.0,13.9,3.3,2.4,sun
      2015-04-16,0.0,17.8,3.9,3.1,sun
      2015-04-17,0.0,18.9,6.1,3.6,sun
      2015-04-18,0.0,18.9,8.3,3.9,sun
      2015-04-19,0.0,21.1,8.3,3.6,sun
      2015-04-20,0.0,22.8,7.8,2.6,sun
      2015-04-21,5.6,17.2,6.7,3.4,rain
      2015-04-22,0.0,15.6,5.0,2.3,sun
      2015-04-23,3.0,12.2,6.7,4.1,rain
      2015-04-24,3.3,12.2,6.1,5.0,rain
      2015-04-25,1.3,13.3,5.6,3.0,rain
      2015-04-26,0.0,15.6,4.4,2.7,fog
      2015-04-27,0.3,25.0,10.6,2.3,rain
      2015-04-28,1.8,15.6,8.9,4.3,rain
      2015-04-29,0.0,16.1,7.2,4.7,sun
      2015-04-30,0.0,17.2,7.8,2.1,sun
      2015-05-01,0.0,18.3,8.9,3.7,sun
      2015-05-02,0.0,18.3,7.8,3.7,sun
      2015-05-03,0.0,20.6,7.8,2.6,sun
      2015-05-04,0.0,17.2,7.2,5.2,sun
      2015-05-05,6.1,14.4,7.2,5.1,rain
      2015-05-06,0.0,16.7,7.2,2.6,fog
      2015-05-07,0.0,20.6,6.1,3.0,sun
      2015-05-08,0.0,23.9,8.3,3.0,sun
      2015-05-09,0.0,26.7,9.4,2.6,sun
      2015-05-10,0.0,19.4,11.1,2.8,sun
      2015-05-11,0.0,13.9,10.0,2.5,fog
      2015-05-12,4.3,15.6,10.6,3.3,rain
      2015-05-13,4.1,12.2,10.0,2.8,rain
      2015-05-14,0.3,17.8,9.4,2.0,rain
      2015-05-15,0.0,20.0,9.4,2.8,fog
      2015-05-16,0.0,15.6,11.1,3.0,sun
      2015-05-17,0.0,19.4,10.6,2.1,sun
      2015-05-18,0.0,25.6,12.2,3.0,sun
      2015-05-19,0.0,21.7,11.7,2.6,sun
      2015-05-20,0.0,23.3,10.6,1.8,fog
      2015-05-21,0.0,25.6,11.7,2.1,sun
      2015-05-22,0.0,16.7,11.7,3.7,sun
      2015-05-23,0.0,16.1,11.7,2.6,sun
      2015-05-24,0.0,17.8,11.1,2.7,sun
      2015-05-25,0.0,15.6,11.1,2.7,sun
      2015-05-26,0.0,21.7,11.7,2.1,sun
      2015-05-27,0.0,24.4,11.7,1.8,sun
      2015-05-28,0.0,27.8,12.2,2.1,sun
      2015-05-29,0.0,26.1,12.8,2.5,sun
      2015-05-30,0.0,22.8,10.0,2.5,sun
      2015-05-31,0.0,25.0,11.7,2.2,sun
      2015-06-01,4.6,16.1,11.7,3.4,rain
      2015-06-02,0.5,17.8,12.8,5.0,rain
      2015-06-03,0.0,20.0,11.7,3.0,sun
      2015-06-04,0.0,22.8,11.7,3.9,sun
      2015-06-05,0.0,26.7,12.8,4.3,sun
      2015-06-06,0.0,29.4,13.3,2.6,sun
      2015-06-07,0.0,31.1,15.6,3.2,sun
      2015-06-08,0.0,30.6,14.4,3.5,sun
      2015-06-09,0.0,28.9,14.4,2.7,sun
      2015-06-10,0.0,25.6,11.1,3.0,sun
      2015-06-11,0.0,24.4,11.1,3.5,sun
      2015-06-12,0.0,20.0,11.7,2.3,sun
      2015-06-13,0.0,23.9,9.4,2.6,sun
      2015-06-14,0.0,27.8,11.7,3.7,sun
      2015-06-15,0.0,30.0,16.1,3.5,drizzle
      2015-06-16,0.0,22.8,11.1,3.0,sun
      2015-06-17,0.0,25.0,11.1,3.1,sun
      2015-06-18,0.0,24.4,13.9,3.0,sun
      2015-06-19,0.5,23.9,13.3,3.2,rain
      2015-06-20,0.0,25.0,12.8,4.3,sun
      2015-06-21,0.0,25.6,13.9,3.4,sun
      2015-06-22,0.0,25.0,12.8,2.4,sun
      2015-06-23,0.0,26.1,11.7,2.4,sun
      2015-06-24,0.0,25.6,16.1,2.6,sun
      2015-06-25,0.0,30.6,15.6,3.0,sun
      2015-06-26,0.0,31.7,17.8,4.7,sun
      2015-06-27,0.0,33.3,17.2,3.9,sun
      2015-06-28,0.3,28.3,18.3,2.1,rain
      2015-06-29,0.0,28.9,17.2,2.7,sun
      2015-06-30,0.0,30.6,15.0,3.4,fog
      2015-07-01,0.0,32.2,17.2,4.3,sun
      2015-07-02,0.0,33.9,17.8,3.4,sun
      2015-07-03,0.0,33.3,17.8,2.6,sun
      2015-07-04,0.0,33.3,15.0,2.9,sun
      2015-07-05,0.0,32.8,16.7,2.1,sun
      2015-07-06,0.0,29.4,15.6,3.2,drizzle
      2015-07-07,0.0,27.2,13.9,2.4,sun
      2015-07-08,0.0,30.0,14.4,1.9,drizzle
      2015-07-09,0.0,28.9,14.4,3.4,sun
      2015-07-10,0.0,21.1,16.7,3.7,sun
      2015-07-11,0.0,22.2,16.7,3.0,sun
      2015-07-12,0.0,26.1,16.7,2.2,sun
      2015-07-13,0.0,25.6,16.1,3.1,sun
      2015-07-14,0.0,27.8,16.1,3.3,sun
      2015-07-15,0.0,26.1,14.4,3.2,sun
      2015-07-16,0.0,26.1,15.0,2.8,sun
      2015-07-17,0.0,27.8,13.9,3.3,sun
      2015-07-18,0.0,33.3,17.8,3.4,sun
      2015-07-19,0.0,35.0,17.2,3.3,sun
      2015-07-20,0.0,26.7,16.7,3.9,sun
      2015-07-21,0.0,23.9,15.0,2.4,sun
      2015-07-22,0.0,23.9,13.9,2.8,sun
      2015-07-23,0.0,26.1,14.4,1.9,sun
      2015-07-24,0.3,22.8,13.3,3.8,rain
      2015-07-25,0.0,21.1,14.4,2.4,fog
      2015-07-26,2.0,22.2,13.9,2.6,rain
      2015-07-27,0.0,23.3,12.2,1.9,fog
      2015-07-28,0.0,27.8,13.9,3.4,sun
      2015-07-29,0.0,32.2,14.4,3.8,sun
      2015-07-30,0.0,34.4,17.2,3.5,sun
      2015-07-31,0.0,34.4,17.8,2.6,sun
      2015-08-01,0.0,33.3,15.6,3.1,sun
      2015-08-02,0.0,30.6,16.1,2.0,sun
      2015-08-03,0.0,28.3,17.2,2.3,sun
      2015-08-04,0.0,26.1,14.4,2.6,fog
      2015-08-05,0.0,23.3,12.2,3.5,sun
      2015-08-06,0.0,25.0,15.0,2.9,sun
      2015-08-07,0.0,28.3,15.6,3.7,sun
      2015-08-08,0.0,25.0,15.6,3.6,fog
      2015-08-09,0.0,28.3,15.0,2.2,sun
      2015-08-10,0.0,28.9,16.1,2.4,sun
      2015-08-11,0.0,30.0,16.7,4.4,sun
      2015-08-12,7.6,28.3,16.7,2.7,rain
      2015-08-13,0.0,28.3,15.6,2.2,sun
      2015-08-14,30.5,18.3,15.0,5.2,rain
      2015-08-15,0.0,21.7,13.9,3.7,sun
      2015-08-16,0.0,25.0,14.4,3.7,sun
      2015-08-17,0.0,27.2,13.9,3.0,sun
      2015-08-18,0.0,30.0,15.0,3.0,sun
      2015-08-19,0.0,31.7,16.1,2.1,drizzle
      2015-08-20,2.0,22.8,14.4,4.2,rain
      2015-08-21,0.0,22.2,14.4,2.6,sun
      2015-08-22,0.0,26.7,12.2,2.5,drizzle
      2015-08-23,0.0,27.8,13.9,1.8,drizzle
      2015-08-24,0.0,23.9,12.2,2.3,sun
      2015-08-25,0.0,25.6,12.2,3.4,sun
      2015-08-26,0.0,28.3,13.9,1.7,sun
      2015-08-27,0.0,29.4,14.4,2.1,sun
      2015-08-28,0.5,23.3,15.6,2.6,rain
      2015-08-29,32.5,22.2,13.3,5.8,rain
      2015-08-30,10.2,20.0,12.8,4.7,rain
      2015-08-31,0.0,18.9,16.1,5.8,sun
      2015-09-01,5.8,19.4,13.9,5.0,rain
      2015-09-02,0.0,19.4,11.1,3.8,sun
      2015-09-03,0.0,18.3,10.6,2.9,sun
      2015-09-04,0.0,18.3,10.0,2.9,sun
      2015-09-05,0.3,20.6,8.9,3.5,rain
      2015-09-06,5.3,16.1,11.7,2.4,rain
      2015-09-07,0.3,21.1,13.3,1.5,rain
      2015-09-08,0.0,22.8,13.3,2.4,sun
      2015-09-09,0.0,24.4,13.9,3.3,sun
      2015-09-10,0.0,25.0,14.4,3.6,fog
      2015-09-11,0.0,27.2,15.0,3.1,sun
      2015-09-12,0.0,26.7,14.4,2.1,sun
      2015-09-13,0.5,20.6,12.8,3.0,rain
      2015-09-14,0.0,16.7,10.6,3.4,sun
      2015-09-15,0.0,17.8,10.0,2.8,sun
      2015-09-16,1.0,20.0,10.0,1.9,rain
      2015-09-17,1.8,18.3,12.8,3.8,rain
      2015-09-18,0.0,19.4,12.8,2.6,sun
      2015-09-19,0.0,21.1,14.4,4.3,sun
      2015-09-20,4.1,22.8,12.2,6.8,rain
      2015-09-21,0.0,18.3,9.4,2.7,fog
      2015-09-22,0.0,18.9,7.8,2.0,sun
      2015-09-23,0.0,20.6,8.3,1.8,sun
      2015-09-24,0.0,22.2,11.1,2.5,fog
      2015-09-25,2.0,15.6,12.8,2.6,rain
      2015-09-26,0.0,18.3,10.0,2.7,sun
      2015-09-27,0.0,17.8,7.2,3.8,sun
      2015-09-28,0.0,21.1,9.4,5.1,sun
      2015-09-29,0.0,21.7,8.9,1.9,sun
      2015-09-30,0.0,18.3,10.0,1.3,fog
      2015-10-01,0.0,21.1,9.4,1.3,fog
      2015-10-02,0.0,15.6,10.0,2.9,fog
      2015-10-03,0.0,19.4,11.1,4.8,sun
      2015-10-04,0.0,22.8,10.0,3.7,sun
      2015-10-05,0.0,23.3,9.4,1.6,sun
      2015-10-06,0.0,18.3,10.0,2.6,drizzle
      2015-10-07,9.9,16.1,13.9,2.2,rain
      2015-10-08,0.0,18.9,13.3,1.1,fog
      2015-10-09,0.3,19.4,12.2,2.6,rain
      2015-10-10,28.7,21.1,13.3,4.7,rain
      2015-10-11,0.0,17.8,10.6,2.6,sun
      2015-10-12,4.6,18.3,10.6,2.8,rain
      2015-10-13,1.3,16.7,9.4,3.2,rain
      2015-10-14,0.0,15.0,10.0,5.0,fog
      2015-10-15,0.0,21.1,9.4,3.4,fog
      2015-10-16,0.0,20.0,8.9,1.3,sun
      2015-10-17,0.3,19.4,11.7,1.3,rain
      2015-10-18,3.8,15.0,12.8,2.0,rain
      2015-10-19,0.3,17.2,12.2,2.6,rain
      2015-10-20,0.0,17.8,10.6,1.8,fog
      2015-10-21,0.0,16.1,8.3,1.3,fog
      2015-10-22,0.0,16.1,8.9,2.7,fog
      2015-10-23,0.0,12.8,7.2,2.6,fog
      2015-10-24,0.0,15.0,8.9,2.9,fog
      2015-10-25,8.9,19.4,8.9,3.4,rain
      2015-10-26,6.9,12.2,10.0,4.6,rain
      2015-10-27,0.0,16.1,7.8,1.7,fog
      2015-10-28,3.3,13.9,11.1,2.8,rain
      2015-10-29,1.8,15.0,12.2,4.7,rain
      2015-10-30,19.3,17.2,11.7,6.7,rain
      2015-10-31,33.0,15.6,11.7,7.2,rain
      2015-11-01,26.2,12.2,8.9,6.0,rain
      2015-11-02,0.3,11.1,7.2,2.8,rain
      2015-11-03,0.8,10.6,5.0,1.4,rain
      2015-11-04,0.0,10.0,3.3,2.2,sun
      2015-11-05,1.3,11.7,7.8,2.3,rain
      2015-11-06,0.0,15.6,8.3,2.7,fog
      2015-11-07,12.7,12.2,9.4,3.0,rain
      2015-11-08,6.6,11.1,7.8,1.8,rain
      2015-11-09,3.3,10.0,5.0,1.3,rain
      2015-11-10,1.3,11.1,3.9,3.9,rain
      2015-11-11,1.5,11.1,6.1,4.6,rain
      2015-11-12,9.9,11.1,5.0,5.1,rain
      2015-11-13,33.5,13.3,9.4,6.5,rain
      2015-11-14,47.2,9.4,6.1,4.5,rain
      2015-11-15,22.4,8.9,2.2,4.1,rain
      2015-11-16,2.0,8.9,1.7,4.0,rain
      2015-11-17,29.5,13.3,6.7,8.0,rain
      2015-11-18,1.5,8.9,3.3,3.8,rain
      2015-11-19,2.0,8.9,2.8,4.2,rain
      2015-11-20,0.0,8.3,0.6,4.0,fog
      2015-11-21,0.0,8.9,0.6,4.7,sun
      2015-11-22,0.0,10.0,1.7,3.1,fog
      2015-11-23,3.0,6.7,0.0,1.3,rain
      2015-11-24,7.1,6.7,2.8,4.5,rain
      2015-11-25,0.0,7.2,0.0,5.7,sun
      2015-11-26,0.0,9.4,-1.0,4.3,sun
      2015-11-27,0.0,9.4,-1.6,3.0,sun
      2015-11-28,0.0,7.2,-2.7,1.0,sun
      2015-11-29,0.0,1.7,-2.1,0.9,fog
      2015-11-30,0.5,5.6,-3.8,1.7,rain
      2015-12-01,12.2,10.0,3.9,3.5,rain
      2015-12-02,2.5,10.6,4.4,5.0,rain
      2015-12-03,12.7,15.6,7.8,5.9,rain
      2015-12-04,2.0,10.6,6.1,4.7,rain
      2015-12-05,15.7,10.0,6.1,4.0,rain
      2015-12-06,11.2,12.8,7.2,5.9,rain
      2015-12-07,27.4,11.1,8.3,3.4,rain
      2015-12-08,54.1,15.6,10.0,6.2,rain
      2015-12-09,13.5,12.2,7.8,6.3,rain
      2015-12-10,9.4,11.7,6.1,7.5,rain
      2015-12-11,0.3,9.4,4.4,2.8,rain
      2015-12-12,16.0,8.9,5.6,5.6,rain
      2015-12-13,1.3,7.8,6.1,6.1,rain
      2015-12-14,0.0,7.8,1.7,1.7,sun
      2015-12-15,1.5,6.7,1.1,2.9,rain
      2015-12-16,3.6,6.1,2.8,2.3,rain
      2015-12-17,21.8,6.7,3.9,6.0,rain
      2015-12-18,18.5,8.9,4.4,5.1,rain
      2015-12-19,0.0,8.3,2.8,4.1,fog
      2015-12-20,4.3,7.8,4.4,6.7,rain
      2015-12-21,27.4,5.6,2.8,4.3,rain
      2015-12-22,4.6,7.8,2.8,5.0,rain
      2015-12-23,6.1,5.0,2.8,7.6,rain
      2015-12-24,2.5,5.6,2.2,4.3,rain
      2015-12-25,5.8,5.0,2.2,1.5,rain
      2015-12-26,0.0,4.4,0.0,2.5,sun
      2015-12-27,8.6,4.4,1.7,2.9,rain
      2015-12-28,1.5,5.0,1.7,1.3,rain
      2015-12-29,0.0,7.2,0.6,2.6,fog
      2015-12-30,0.0,5.6,-1.0,3.4,sun
      2015-12-31,0.0,5.6,-2.1,3.5,sun

# vw_load() works

    Code
      vw_load(tmpfile)
    Output
      [1] "foobar"

---

    Code
      ct$eval(glue_js("(async () => {console.log(await vwLoad('${tmpfile}'))})()"))
    Output
      foobar
      [1] "[object Promise]"

