% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vega-embed.R
\name{vega_embed}
\alias{vega_embed}
\title{Vega embed options}
\usage{
vega_embed(
  renderer = c("canvas", "svg"),
  actions = NULL,
  defaultStyle = TRUE,
  config = NULL,
  patch = NULL,
  bind = NULL,
  ...
)
}
\arguments{
\item{renderer}{\code{character} the renderer to use for the view.
One of \code{"canvas"} (default) or \code{"svg"}.
See \href{https://vega.github.io/vega/docs/api/view/#view_renderer}{Vega docs}
for details.}

\item{actions}{\code{logical} or named vector of logicals, determines if action links
("Export as PNG/SVG", "View Source", "Open in Vega Editor")
are included with the embedded view.
If the value is \code{TRUE} (default), all action links will be shown
and none if the value is \code{FALSE}. This property can be a named vector of
logicals that maps
keys (\code{export}, \code{source}, \code{compiled}, \code{editor}) to logical values for determining
if each action link should be shown. By default, \code{export}, \code{source},
and \code{editor} are \code{TRUE} and \code{compiled} is \code{FALSE}, but these defaults
can be overridden. For example, if \code{actions} is
\code{list(export =  FALSE, source = TRUE)}, the embedded visualization will
have two links – "View Source" and "Open in Vega Editor".}

\item{defaultStyle}{\code{logical} or \code{character}
default stylesheet for embed actions. If set to \code{TRUE} (default),
the embed actions are shown in a menu. Set to \code{FALSE} to use simple links.
Provide a \code{character} string to set the style sheet.}

\item{config}{\code{character} or \code{list}, a URL string from which to load
a Vega/Vega-Lite or Vega-Lite configuration file, or a \code{list} of
Vega/Vega-Lite configurations to override the default configuration
options. If \code{config} is a URL, it will be subject to standard browser
security restrictions. Typically this URL will point to a file on the same
host and port number as the web page itself.}

\item{patch}{\code{JS} function, \code{list} or \code{character}, A function to modify the
Vega specification before it is parsed. Alternatively, an \code{list} that,
when compiled to JSON, will meet
\href{https://tools.ietf.org/html/rfc6902}{JSON-Patch RFC6902}.
If you use Vega-Lite, the compiled Vega will be patched.
Alternatively to the function or the \code{list}, a URL string from which to
load the patch can be provided. This URL will be subject to standard
browser security restrictions. Typically this URL will point to a file
on the same host and port number as the web page itself.}

\item{bind}{\code{character}}

\item{...}{other named items, outlined in
\href{https://github.com/vega/vega-embed}{vega-embed} options.}
}
\value{
\code{list} to to be used with vega-embed JavaScript library
}
\description{
Helper-function to specify the \code{embed} argument to \code{vegawidget()}.
These arguments reflect the options to the
\href{https://github.com/vega/vega-embed/#options}{vega-embed}
library, which ultimately renders the chart specification as HTML.
}
\details{
The most important arguments are \code{renderer}, \code{actions}, and \code{defaultStyle}:
\itemize{
\item The default \code{renderer} is \code{"canvas"}.
\item The default for \code{actions} is \code{NULL}, which means that the \code{export},
\code{source}, and \code{editor} links are shown, but the \code{compiled} link is
not shown.
\itemize{
\item To suppress all action links, call with \code{actions = FALSE}.
\item To change from the default for a given action link, call with a list:
\code{actions = list(editor = FALSE)}.
}
\item The default for \code{defaultStyle} is \code{TRUE}, which means that action-links
are rendered in a widget at the upper-right corner of the rendered chart.
}

The \href{https://github.com/vega/vega-embed/#options}{vega-embed} library has a lot
more options, you can supply these as names arguments using \code{...}.

For example, it is ineffective to set the \code{width} and \code{height} parameters
here when embedding a Vega-Lite specification, as they will be overridden
by the value in the chart specification.
}
\examples{
vega_embed(renderer = "svg")

}
\seealso{
\href{https://github.com/vega/vega-embed}{vega-embed library},
\code{\link[=vegawidget]{vegawidget()}}
}
