% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcmap.R
\docType{methods}
\name{vcmap}
\alias{vcmap}
\title{Generate choropleth map with interactive functions}
\usage{
vcmap(shapefile, data, mid, did, name, tag, path = tempdir(), fill = NULL,
  ggscale = NULL)
}
\arguments{
\item{shapefile}{path to ESRI shapefile to draw choropleth map}

\item{data}{data frame for default data set}

\item{mid}{unique id in the attribute table of the shape file for linking the data frame \code{data}}

\item{did}{unique id in the data frame \code{data} for linking the attribute table of the shape file}

\item{name}{character for the name of the generated scatter plot}

\item{tag}{character for the common name of a series of linked plots}

\item{path}{character string of a directory for writing HTML and SVG files}

\item{fill}{column name assigned to the color of polygons}

\item{ggscale}{color scale generated by scale_fill_* function}
}
\description{
\code{vcmap} generates choropleth map with interactive functions.
}
\examples{
data(vsfuk2012)
shp.path <- file.path(system.file(package="vdmR"), "etc/shapes/kitakyu2012.shp")
kk2012 <- dplyr::filter(vsfuk2012, CityCode<40110&CityCode>40100)
vcmap(shp.path, kk2012, "CityCode", "CityCode", "map1", "kk2012")
vlaunch(kk2012, "main", "kk2012", browse=FALSE)

}
