% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relGV.multi.R
\name{relGV.multi}
\alias{relGV.multi}
\title{Ratio of generalized variances}
\usage{
relGV.multi(Sm, logGV = TRUE)
}
\arguments{
\item{Sm}{a (p x p x m) array of covariance matrices,
where p is the number of variables and m the number of groups.}

\item{logGV}{a logical argument to indicate if the ratios should be log-transformed}
}
\value{
The matrix of the (log-transformed) ratios of the generalized variances.
For each row, the ratio corrresponds to the group of the row
relative to the group of a column.
}
\description{
Computes the (log-transformed) ratios of the generalized variances
of a set of covariance matrices
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus")
PHEN <- as.matrix(Tropheus[which(names(Tropheus) == "X1"):which(names(Tropheus) == "Y19")])

# Procrustes superimposition
library("geomorph")
PHEN_array <- arrayspecs(PHEN, p = 19, k = 2)
phen.gpa <- gpagen(PHEN_array, print.progress = FALSE)
proc.coord <- two.d.array(phen.gpa$coords)

# Data reduction
phen.pca <- prcomp(proc.coord, rank. = 5, tol = sqrt(.Machine$double.eps))
pc.scores <- phen.pca$x

# Covariance matrix of each population
S.phen.pop <- cov.group(pc.scores, groups = Tropheus$POP.ID)

# Ratio of the generalized variances of 2 populations (IKA1 and IKS5)
relGV.multi(S.phen.pop[, , c("IKA1", "IKS5")], logGV = FALSE)

}
