% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\name{name_spec}
\alias{name_spec}
\title{Name specifications}
\arguments{
\item{name_spec, .name_spec}{A name specification for combining
inner and outer names. This is relevant for inputs passed with a
name, when these inputs are themselves named, like \code{outer = c(inner = 1)}, or when they have length greater than 1: \code{outer = 1:2}. By default, these cases trigger an error. You can resolve
the error by providing a specification that describes how to
combine the names or the indices of the inner vector with the
name of the input. This specification can be:
\itemize{
\item A function of two arguments. The outer name is passed as a
string to the first argument, and the inner names or positions
are passed as second argument.
\item An anonymous function as a purrr-style formula.
\item A glue specification of the form \code{"{outer}_{inner}"}.
\item An \code{\link[rlang:zap]{rlang::zap()}} object, in which case both outer and inner
names are ignored and the result is unnamed.
}

See the \link[=name_spec]{name specification topic}.}
}
\description{
A name specification describes how to combine an inner and outer
names. This sort of name combination arises when concatenating
vectors or flattening lists. There are two possible cases:
\itemize{
\item Named vector:

\if{html}{\out{<div class="sourceCode">}}\preformatted{vec_c(outer = c(inner1 = 1, inner2 = 2))
}\if{html}{\out{</div>}}
\item Unnamed vector:

\if{html}{\out{<div class="sourceCode">}}\preformatted{vec_c(outer = 1:2)
}\if{html}{\out{</div>}}
}

In r-lib and tidyverse packages, these cases are errors by default,
because there's no behaviour that works well for every case.
Instead, you can provide a name specification that describes how to
combine the inner and outer names of inputs. Name specifications
can refer to:
\itemize{
\item \code{outer}: The external name recycled to the size of the input
vector.
\item \code{inner}: Either the names of the input vector, or a sequence of
integer from 1 to the size of the vector if it is unnamed.
}
}
\examples{
# By default, named inputs must be length 1:
vec_c(name = 1)         # ok
try(vec_c(name = 1:3))  # bad

# They also can't have internal names, even if scalar:
try(vec_c(name = c(internal = 1)))  # bad

# Pass a name specification to work around this. A specification
# can be a glue string referring to `outer` and `inner`:
vec_c(name = 1:3, other = 4:5, .name_spec = "{outer}")
vec_c(name = 1:3, other = 4:5, .name_spec = "{outer}_{inner}")

# They can also be functions:
my_spec <- function(outer, inner) paste(outer, inner, sep = "_")
vec_c(name = 1:3, other = 4:5, .name_spec = my_spec)

# Or purrr-style formulas for anonymous functions:
vec_c(name = 1:3, other = 4:5, .name_spec = ~ paste0(.x, .y))
}
