% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{vec_slice}
\alias{vec_slice}
\alias{vec_slice<-}
\alias{vec_assign}
\title{Get or set observations in a vector}
\usage{
vec_slice(x, i)

vec_slice(x, i) <- value

vec_assign(x, i, value, ..., x_arg = "", value_arg = "")
}
\arguments{
\item{x}{A vector}

\item{i}{An integer, character or logical vector specifying the
locations or names of the observations to get/set. Specify
\code{TRUE} to index all elements (as in \code{x[]}), or \code{NULL}, \code{FALSE} or
\code{integer()} to index none (as in \code{x[NULL]}).}

\item{value}{Replacement values. \code{value} is cast to the type of
\code{x}, but only if they have a common type. See below for examples
of this rule.}

\item{...}{These dots are for future extensions and must be empty.}

\item{x_arg, value_arg}{Argument names for \code{x} and \code{value}. These are used
in error messages to inform the user about the locations of
incompatible types and sizes (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}} and
\code{\link[=stop_incompatible_size]{stop_incompatible_size()}}).}
}
\value{
A vector of the same type as \code{x}.
}
\description{
This provides a common interface to extracting and modifying observations
for all vector types, regardless of dimensionality. It is an analog to \code{[}
that matches \code{\link[=vec_size]{vec_size()}} instead of \code{length()}.
}
\section{Genericity}{


Support for S3 objects depends on whether the object implements a
\code{\link[=vec_proxy]{vec_proxy()}} method.
\itemize{
\item When a \code{vec_proxy()} method exists, the proxy is sliced and
\code{vec_restore()} is called on the result.
\item Otherwise \code{vec_slice()} falls back to the base generic \code{[}.
}

Note that S3 lists are treated as scalars by default, and will
cause an error if they don't implement a \code{\link[=vec_proxy]{vec_proxy()}} method.
}

\section{Differences with base R subsetting}{

\itemize{
\item \code{vec_slice()} only slices along one dimension. For
two-dimensional types, the first dimension is subsetted.
\item \code{vec_slice()} preserves attributes by default.
\item \verb{vec_slice<-()} is type-stable and always returns the same type
as the LHS.
}
}

\section{Dependencies}{

\subsection{vctrs dependencies}{
\itemize{
\item \code{\link[=vec_proxy]{vec_proxy()}}
\item \code{\link[=vec_restore]{vec_restore()}}
}
}

\subsection{base dependencies}{
\itemize{
\item \code{base::`[`}
}

If a non-data-frame vector class doesn't have a \code{\link[=vec_proxy]{vec_proxy()}}
method, the vector is sliced with \code{[} instead.
}
}

\examples{
x <- sample(10)
x
vec_slice(x, 1:3)

# You can assign with the infix variant:
vec_slice(x, 2) <- 100
x

# Or with the regular variant that doesn't modify the original input:
y <- vec_assign(x, 3, 500)
y
x


# Slicing objects of higher dimension:
vec_slice(mtcars, 1:3)

# Type stability --------------------------------------------------

# The assign variant is type stable. It always returns the same
# type as the input.
x <- 1:5
vec_slice(x, 2) <- 20.0

# `x` is still an integer vector because the RHS was cast to the
# type of the LHS:
vec_ptype(x)

# Compare to `[<-`:
x[2] <- 20.0
vec_ptype(x)


# Note that the types must be coercible for the cast to happen.
# For instance, you can cast a double vector of whole numbers to an
# integer vector:
vec_cast(1, integer())

# But not fractional doubles:
try(vec_cast(1.5, integer()))

# For this reason you can't assign fractional values in an integer
# vector:
x <- 1:3
try(vec_slice(x, 2) <- 1.5)
}
\keyword{internal}
