% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rep.R
\name{vec-rep}
\alias{vec-rep}
\alias{vec_rep}
\alias{vec_rep_each}
\title{Repeat a vector}
\usage{
vec_rep(x, times)

vec_rep_each(x, times)
}
\arguments{
\item{x}{A vector.}

\item{times}{For \code{vec_rep()}, a single integer for the number of times to repeat
the entire vector.

For \code{vec_rep_each()}, an integer vector of the number of times to repeat
each element of \code{x}. \code{times} will be recycled to the size of \code{x}.}
}
\value{
For \code{vec_rep()}, a vector the same type as \code{x} with size
\code{vec_size(x) * times}.

For \code{vec_rep_each()}, a vector the same type as \code{x} with size
\code{sum(vec_recycle(times, vec_size(x)))}.
}
\description{
\itemize{
\item \code{vec_rep()} repeats an entire vector a set number of \code{times}.
\item \code{vec_rep_each()} repeats each element of a vector a set number of \code{times}.
}
}
\details{
\code{vec_rep()} and \code{vec_rep_each()} work along the size of \code{x}, rather than
its length. For data frames, this means that rows are repeated rather
than columns.
}
\examples{
# Repeat the entire vector
vec_rep(1:2, 3)

# Repeat within each vector
vec_rep_each(1:2, 3)
vec_rep_each(1:2, c(3, 4))

df <- data.frame(x = 1:2, y = 3:4)

# `rep()` repeats columns of data frames, and returns lists
rep(df, each = 2)

# `vec_rep()` and `vec_rep_each()` repeat rows, and return data frames
vec_rep(df, 2)
vec_rep_each(df, 2)
}
