% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_client_auth_approle.R
\name{vault_client_auth_approle}
\alias{vault_client_auth_approle}
\title{Vault AppRole Authentication Configuration}
\description{
Vault AppRole Authentication Configuration

Vault AppRole Authentication Configuration
}
\details{
Interact with vault's AppRole authentication backend.  For more
details about this, see the vault documentation at
https://www.vaultproject.io/docs/auth/approle.html
}
\examples{

vaultr::vault_client(addr = "https://localhost:8200")$auth$approle
}
\section{Super class}{
\code{\link[vaultr:vault_client_object]{vaultr::vault_client_object}} -> \code{vault_client_auth_approle}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-vault_client_auth_approle-new}{\code{vault_client_auth_approle$new()}}
\item \href{#method-vault_client_auth_approle-custom_mount}{\code{vault_client_auth_approle$custom_mount()}}
\item \href{#method-vault_client_auth_approle-role_list}{\code{vault_client_auth_approle$role_list()}}
\item \href{#method-vault_client_auth_approle-role_write}{\code{vault_client_auth_approle$role_write()}}
\item \href{#method-vault_client_auth_approle-role_read}{\code{vault_client_auth_approle$role_read()}}
\item \href{#method-vault_client_auth_approle-role_delete}{\code{vault_client_auth_approle$role_delete()}}
\item \href{#method-vault_client_auth_approle-role_id_read}{\code{vault_client_auth_approle$role_id_read()}}
\item \href{#method-vault_client_auth_approle-role_id_write}{\code{vault_client_auth_approle$role_id_write()}}
\item \href{#method-vault_client_auth_approle-secret_id_generate}{\code{vault_client_auth_approle$secret_id_generate()}}
\item \href{#method-vault_client_auth_approle-secret_id_list}{\code{vault_client_auth_approle$secret_id_list()}}
\item \href{#method-vault_client_auth_approle-secret_id_read}{\code{vault_client_auth_approle$secret_id_read()}}
\item \href{#method-vault_client_auth_approle-secret_id_delete}{\code{vault_client_auth_approle$secret_id_delete()}}
\item \href{#method-vault_client_auth_approle-login}{\code{vault_client_auth_approle$login()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="format"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-format'><code>vaultr::vault_client_object$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="help"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-help'><code>vaultr::vault_client_object$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-new"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{vault_client_approle} object. Not typically
called by users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$new(api_client, mount)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_client}}{A \link{vault_api_client} object}

\item{\code{mount}}{Mount point for the backend}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-custom_mount"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-custom_mount}{}}}
\subsection{Method \code{custom_mount()}}{
Set up a \code{vault_client_auth_approle} object at a
custom mount. For example, suppose you mounted the \code{approle}
authentication backend at \verb{/approle-dev} you might use \code{ar <- vault$auth$approle2$custom_mount("/approle-dev")} - this pattern
is repeated for other secret and authentication backends.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$custom_mount(mount)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mount}}{String, indicating the path that the engine is mounted at.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-role_list"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-role_list}{}}}
\subsection{Method \code{role_list()}}{
This endpoint returns a list the existing AppRoles in the method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$role_list()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-role_write"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-role_write}{}}}
\subsection{Method \code{role_write()}}{
Creates a new AppRole or updates an existing AppRole. This
endpoint supports both create and update capabilities. There can
be one or more constraints enabled on the role. It is required to
have at least one of them enabled while creating or updating a
role.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$role_write(
  role_name,
  bind_secret_id = NULL,
  secret_id_bound_cidrs = NULL,
  token_bound_cidrs = NULL,
  policies = NULL,
  secret_id_num_uses = NULL,
  secret_id_ttl = NULL,
  token_num_uses = NULL,
  token_ttl = NULL,
  token_max_ttl = NULL,
  period = NULL,
  enable_local_secret_ids = NULL,
  token_type = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role_name}}{Name of the AppRole}

\item{\code{bind_secret_id}}{Require secret_id to be presented when
logging in using this AppRole (boolean, default is \code{TRUE}).}

\item{\code{secret_id_bound_cidrs}}{Character vector of CIDR blocks;
if set, specifies blocks of IP addresses which can perform
the login operation.}

\item{\code{token_bound_cidrs}}{Character vector of if set, specifies
blocks of IP addresses which can use the auth tokens
generated by this role.}

\item{\code{policies}}{Character vector of policies set on tokens
issued via this AppRole.}

\item{\code{secret_id_num_uses}}{Number of times any particular
SecretID can be used to fetch a token from this AppRole,
after which the SecretID will expire. A value of zero will
allow unlimited uses.}

\item{\code{secret_id_ttl}}{Duration, after which any SecretID expires.}

\item{\code{token_num_uses}}{Number of times issued tokens can be
used. A value of 0 means unlimited uses}

\item{\code{token_ttl}}{Duration to set as the TTL for issued tokens
and at renewal time.}

\item{\code{token_max_ttl}}{Duration, after which the issued token can
no longer be renewed.}

\item{\code{period}}{A duration; when set, the token generated using
this AppRole is a periodic token; so long as it is renewed it
never expires, but the TTL set on the token at each renewal
is fixed to the value specified here. If this value is
modified, the token will pick up the new value at its next
renewal.}

\item{\code{enable_local_secret_ids}}{Boolean, if \code{TRUE}, then the
secret IDs generated using this role will be cluster
local. This can only be set during role creation and once
set, it can't be reset later.}

\item{\code{token_type}}{The type of token that should be generated
via this role. Can be \code{service}, \code{batch}, or \code{default} to use
the mount's default (which unless changed will be service
tokens).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-role_read"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-role_read}{}}}
\subsection{Method \code{role_read()}}{
Reads the properties of an existing AppRole.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$role_read(role_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role_name}}{Name of the AppRole}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-role_delete"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-role_delete}{}}}
\subsection{Method \code{role_delete()}}{
Deletes an existing AppRole from the method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$role_delete(role_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role_name}}{Name of the AppRole to delete}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-role_id_read"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-role_id_read}{}}}
\subsection{Method \code{role_id_read()}}{
Reads the RoleID of an existing AppRole.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$role_id_read(role_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role_name}}{Name of the AppRole}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-role_id_write"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-role_id_write}{}}}
\subsection{Method \code{role_id_write()}}{
Updates the RoleID of an existing AppRole to a
custom value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$role_id_write(role_name, role_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role_name}}{Name of the AppRole (string)}

\item{\code{role_id}}{Value to be set as RoleID (string)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-secret_id_generate"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-secret_id_generate}{}}}
\subsection{Method \code{secret_id_generate()}}{
Generates and issues a new SecretID on an existing
AppRole. Similar to tokens, the response will also contain a
\code{secret_id_accessor} value which can be used to read the
properties of the SecretID without divulging the SecretID
itself, and also to delete the SecretID from the AppRole.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$secret_id_generate(
  role_name,
  metadata = NULL,
  cidr_list = NULL,
  token_bound_cidrs = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role_name}}{Name of the AppRole.}

\item{\code{metadata}}{Metadata to be tied to the SecretID. This
should be a named list of key-value pairs. This metadata will
be set on tokens issued with this SecretID, and is logged in
audit logs in plaintext.}

\item{\code{cidr_list}}{Character vector CIDR blocks enforcing secret
IDs to be used from specific set of IP addresses. If
\code{bound_cidr_list} is set on the role, then the list of CIDR
blocks listed here should be a subset of the CIDR blocks
listed on the role.}

\item{\code{token_bound_cidrs}}{Character vector of CIDR blocks; if
set, specifies blocks of IP addresses which can use the auth
tokens generated by this SecretID. Overrides any role-set
value but must be a subset.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-secret_id_list"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-secret_id_list}{}}}
\subsection{Method \code{secret_id_list()}}{
Lists the accessors of all the SecretIDs issued
against the AppRole. This includes the accessors for "custom"
SecretIDs as well.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$secret_id_list(role_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role_name}}{Name of the AppRole}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-secret_id_read"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-secret_id_read}{}}}
\subsection{Method \code{secret_id_read()}}{
Reads out the properties of a SecretID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$secret_id_read(
  role_name,
  secret_id,
  accessor = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role_name}}{Name of the AppRole}

\item{\code{secret_id}}{Secret ID attached to the role}

\item{\code{accessor}}{Logical, if \code{TRUE}, treat \code{secret_id} as an
accessor rather than a secret id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-secret_id_delete"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-secret_id_delete}{}}}
\subsection{Method \code{secret_id_delete()}}{
Delete an AppRole secret ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$secret_id_delete(
  role_name,
  secret_id,
  accessor = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role_name}}{Name of the AppRole}

\item{\code{secret_id}}{Secret ID attached to the role}

\item{\code{accessor}}{Logical, if \code{TRUE}, treat \code{secret_id} as an
accessor rather than a secret id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_approle-login"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_approle-login}{}}}
\subsection{Method \code{login()}}{
Log into the vault using AppRole authentication.
Normally you would not call this directly but instead use
\verb{$login} with \code{method = "approle"} and proving the \code{role_id}
and \code{secret_id} arguments.  This function returns a vault
token but does not set it as the client token.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_approle$login(role_id, secret_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role_id}}{RoleID of the AppRole}

\item{\code{secret_id}}{SecretID belonging to AppRole}
}
\if{html}{\out{</div>}}
}
}
}
