% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pen_functions.R
\name{Lq}
\alias{Lq}
\title{\eqn{L^q} Norm Penalty}
\usage{
Lq(x, lambda = 1, q = 1)
}
\arguments{
\item{x}{numeric.}

\item{lambda}{non-negative scalar, shrinkage parameter.}

\item{q}{non-negative scalar, norm parameter.}
}
\value{
penalty for values of \code{x}.
}
\description{
Penalty function using the \eqn{L^q} norm, i.e., \eqn{p_{\lambda}(x) = \lambda \| x\|^q}.
}
\examples{

Lq(-5:5)
curve(Lq(x, q = 2), from = -5, to = 5)
}
\author{
Jakob Dambon
}
