"causality" <-
function(x, cause = NULL){
  if(!(class(x)=="varest")){
    stop("\nPlease provide an object of class 'varest', generated by 'var()'.\n")
  }
  K <- x$K
  p <- x$p
  obs <- x$obs
  type <- x$type
  obj.name <- deparse(substitute(x))
  y <- x$y
  y.names <- colnames(x$y)
  if(is.null(cause)){
    cause <- y.names[1]
    warning("\nArgument 'cause' has not been specified;\nusing first variable in 'x$y' as cause variable.\n")
  }
  y1.names <- subset(y.names, subset = y.names %in% cause)
  y2.names <- subset(y.names, subset = !(y.names %in% cause))
  Z <- x$datamat[, -c(1 : K)]
  PI <- B(x)
  if(ncol(PI) > K*p){
    colnames(PI) <- c(rep(y.names, p), colnames(PI)[(K*p + 1):ncol(PI)])
    detcoeff <- length(PI) - K^2 * p
  } else {
    colnames(PI) <- rep(y.names, p)
    detcoeff <- 0
  }
  rownames(PI) <- y.names
  PI.vec <- as.vector(PI)
  temp <- matrix(1 : (K^2), nrow = K, ncol = K)
  colnames(temp) <- y.names
  rownames(temp) <- y.names
  temp <- as.vector(temp[rownames(temp) %in% y2.names, colnames(temp) %in% y1.names ])
  if(p > 1){
    tmp <- temp
    for(i in 1:(p-1)){
      tmp <- c(tmp, temp + i*K^2)
    }
    temp <- tmp
  }
  N <- length(temp)
  R <- matrix(0, nrow = N, ncol = dim(PI)[1] * dim(PI)[2])
  for(i in 1 : N){
    R[i, temp[i]] <- 1
  }
  ##
  ## Granger-causality
  ##
  sigma.u <- crossprod(resid(x)) / (obs - ncol(Z))
  sigma.pi <- kronecker(solve(crossprod(as.matrix(Z))), sigma.u)
  df1 <- p * length(y1.names) * length(y2.names)
  df2 <- K * obs - K^2 * p - detcoeff
  STATISTIC <- t(R %*% PI.vec) %*% solve(R %*% sigma.pi %*% t(R)) %*% R %*% PI.vec / N
  names(STATISTIC) <- "F-Test"
  PARAMETER1 <- df1
  PARAMETER2 <- df2 
  names(PARAMETER1) <- "df1"
  names(PARAMETER2) <- "df2"  
  PVAL <- 1 - pf(STATISTIC, PARAMETER1, PARAMETER2)
  METHOD <- paste("Granger causality H0:", paste(y1.names, collapse=" "), "do not Granger-cause", paste(y2.names, collapse=" "))
  result1 <- list(statistic = STATISTIC, parameter = c(PARAMETER1, PARAMETER2), p.value = PVAL, method = METHOD, data.name = paste("VAR object", obj.name))
  class(result1) <- "htest"
  ##
  ## Instantaneous Causality
  ##
  sigma.u <- crossprod(resid(x)) / (obs - ncol(Z))
  colnames(sigma.u) <- y.names
  rownames(sigma.u) <- y.names
  select <- sigma.u[rownames(sigma.u) %in% y2.names, colnames(sigma.u) %in% y1.names ]
  sig.vech <- sigma.u[lower.tri(sigma.u, diag = TRUE)]
  index <- which(sig.vech %in% select)
  N <- length(index)
  Cmat <- matrix(0, nrow = N, ncol = length(sig.vech))
  for(i in 1 : N){
    Cmat[i, index[i]] <- 1
  }
  Dmat <- .duplicate(K)
  Dinv <- ginv(Dmat)
  lambda.w <- obs %*% t(sig.vech) %*% t(Cmat) %*% solve(2 * Cmat %*% Dinv %*% kronecker(sigma.u, sigma.u) %*% t(Dinv) %*% t(Cmat)) %*% Cmat %*% sig.vech
  STATISTIC <- lambda.w
  names(STATISTIC) <- "Chi-squared"
  PARAMETER <- N
  names(PARAMETER) <- "df"
  PVAL <- 1 - pchisq(STATISTIC, PARAMETER)
  METHOD <- paste("H0: No instantaneous causality between:", paste(y1.names, collapse=" "), "and", paste(y2.names, collapse=" "))
  result2 <- list(statistic = STATISTIC, parameter = PARAMETER, p.value = PVAL, method = METHOD, data.name = paste("VAR object", obj.name))
  class(result2) <- "htest"
  result2
  return(list(Granger = result1, Instant = result2))
}
