\name{predict.varest}

\alias{predict.varest}

\alias{print.varprd}

\encoding{latin1}

\title{Predict method for objects of class varest}

\description{
  Forecating a VAR object of class \sQuote{\code{varest}} with
  confidence bands.
}

\usage{
\method{predict}{varest}(object, ..., n.ahead = 10, ci = 0.95)
}
\arguments{
  \item{object}{An object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}.} 
  \item{n.ahead}{An integer specifying the number of forecast steps.}
  \item{ci}{The forecast confidence interval}
  \item{\dots}{Currently not used.}
}
\details{
  The \code{n.ahead} forecasts are computed recursively for the
  estimated VAR, beginning with \eqn{h = 1, 2, \ldots, n.ahead}:  

  \deqn{
    \bold{y}_{T+1 | T} = A_1 \bold{y}_T  + \ldots A_p \bold{y}_{T+1-p} +
    C D_{T+1}
  }
  
  The variance-covariance matrix of the forecast errors is a function of
  \eqn{\Sigma_u} and \eqn{\Phi_s}. 
}

\value{
  A list with class attribute \sQuote{\code{varprd}} holding the
  following elements:\cr
  
  \item{fcst}{A list of matrices per endogenous variable containing the
    forecasted values with lower and upper bounds as well as the
    confidence interval.} 
  \item{endog}{Matrix of the in-sample endogenous variables.}
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.  
}

\seealso{
  \code{\link{VAR}}, \code{\link{plot.varprd}}
} 

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
predict(var.2c, n.ahead = 8, ci = 0.95) 
}

\keyword{regression}
\concept{VAR}
\concept{Vector autoregressive}
\concept{Forecasts of VAR}
\concept{Prediction of VAR}
