\name{vm.analysis.paired}
\alias{vm.analysis.paired}
\title{Variance mixture analysis on paired data}
\description{Performs variance mixture analysis on paired data}
\usage{vm.analysis.paired(geneId,ratio,meanint=NULL,filename=NULL,gene.anot=NULL,badqual=NULL,qualtol=NULL,n.mixt=NULL,
                             center=TRUE,loess.cor=FALSE,min.rep=2,penalty=c("AIC","BIC")[2],display=TRUE,
                             criterion.1=c("likelihood","parameter")[1], stop.crit.1=1.e-6,
                             criterion.2=c("likelihood","parameter")[1], stop.crit.2=1.e-8)
}
\arguments{
  \item{geneId}{vector with the identifier of each gene (one gene per row)}
  \item{ratio}{matrix of gene log-ratio. The matrix has
                 one gene per row and one replicate per column}
  \item{meanint}{matrix of gene log-intensity}
  \item{filename}{filename for export. If NULL no files are exported}
  \item{gene.anot}{data.frame with further gene anotations}
  \item{badqual}{integer matrix of number of bad quality observation per gene and replicate}
  \item{qualtol}{integer. Genes with more than qualtol bad quality observations are removed
                   from the analysis. This argument is ignored if Badqual is NULL}
  \item{n.mixt}{number of component in the mixture model. If n.mixt=NULL the optimal
                  number of components is computed by the function}
  \item{center}{Logical. If True each array is centered to have a 0 mean log-ratio}
  \item{loess.cor}{Logical. If True then loess transformation of the data is performed.
                    If False no loess transformation is performed}
  \item{min.rep}{Minimum number of non-missing value per gene and per condition. Must be at least 2}
  \item{penalty}{Either "BIC" or "AIC". The criterion for choosing the number of variance groups.}
  \item{display}{Boolean. Should the result of model fitting be displayed on the screen, on the fly.}
  \item{criterion.1}{either "likelihood" or "parameter". The criterion for stopping EM algorithm while
  trying to determine the number of variance groups}
  \item{stop.crit.1}{The stopping relative precision limit for stopping EM algorithm}
  \item{criterion.2}{Either "likelihood" or "parameter". The criterion for stopping EM algorithm while
  trying to estimate the parameters.}
  \item{stop.crit.2}{The stopping relative precision limit for stopping EM algorithm}


} 
\details{We highly recommend the use of pre-normalized data. The function only centers the data set. 
It can only perform very simple global array by array lowess transform. Typically the badqual matrix is generated by
couting the number of times of gene is under the detection threshod (background) or at the saturation level 
on each physical array. A gene with more than "qualtol" bad quality observation is removed from
the analysis. The corrected p-value (controlling FWER) are computed using the Bonferroni correction.\\
The EM algorithm stops when the relative increase in likelihood or relative maximum absolute difference
in parameter value becomes less than the stop.crit value. If t is the iteration number, and the criterion
is likelihood then the stop criterion is (log-like[t]-log-like[t-1])/log-lik[t-1]<stop.crit}

\value{a gene expression data object with the following elements :
    \item{geneid}{a vector of the vector of gene names}
    \item{raw.ratio}{a matrix of the raw log-ratio }
    \item{raw.meanint}{a matrix of the raw mean log-intensity in condition 2}
    \item{log.ratio}{a matrix of the normalized log-ratio}
    \item{meanint}{a matrix of the normalized mean log-intensity}
    \item{stat1}{a data.frame of results of homoscedastic and gene-specific model}
    \item{stat1.call}{call that generated the stat1 data.frame}
    \item{df}{number of degrees of freedom}
    \item{var.to.vardelta}{factor for computing the test statistic variance given the gene variance}
    \item{residual}{matrix of the residual}
    \item{stat2}{a data frame of results of the variance mixture model analysis}
    \item{stat2.call}{call that generated the stat2 data.frame}
    \item{param}{a data.frame of value of the variance mixture paramters}
    \item{call}{The call to the function}
    \item{ppost}{The matrix of posterior probability that a gene belongs to each variance component. 
                 One row per gene, one column per variance component.}
    \item{choose.nmixt}{A data frame with some information of models with growing number of components}
}

\references{P. Delmar, Robin, S., Tronik-Le Roux S. and Daudin J.-J. (2005) Mixture model on the variance for the differential analysis of gene expression data, JRSS series C, 54(1), 31:50}

\author{Paul Delmar and Julie Aubert}
\note{}

\seealso{\code{\link{fdr.an}}, \code{\link{export.res}},
         \code{\link{plotvm}}, \code{\link{qqplot.vm}}, \code{\link{plotrm}}, \code{\link{boxplotvm}}
        , \code{\link{compute.dif.paired}}}
\examples{
data(spleen.data.vm)
res.spleen<-vm.analysis.paired(geneId=spleen.data.vm$spleen.geneid,ratio=spleen.data.vm$spleen.logratio,
                               meanint=spleen.data.vm$spleen.meanint)
fdr.an(res.spleen,0.01)
res.spleen.data.frame<-export.res(res.spleen)
par(mfrow=c(2,2))
plotvm(res.spleen)
plotrm(res.spleen)
boxplotvm(res.spleen)
qqplot.vm(res.spleen)
}
\keyword{htest}
