% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundWaterEnvironments.R
\name{calcNearbyHydrationFraction}
\alias{calcNearbyHydrationFraction}
\title{Calculate Nearby Atom Hydration Fraction}
\usage{
calcNearbyHydrationFraction(names.res.nearby.atoms)
}
\arguments{
\item{names.res.nearby.atoms}{string of residue-atom name for nearby atoms}
}
\value{
Hydrophilicity fraction sum, mean, and standard deviation.
}
\description{
Calculate the mobility values of waters for a structure.
}
\details{
The summation, mean, and standard deviation of the hydrophilicity
fraction for the protein atoms within the user specified distance for the
\code{\link[=BoundWaterEnvironment]{BoundWaterEnvironment()}} function are calculated and returned.
}
\references{
Paul C Sanschagrin and Leslie A Kuhn. Cluster analysis of
consensus water sites in thrombin and trypsin shows conservation between
serine proteases and contributions to ligand specificity. \emph{Protein
Science}, 1998, \strong{7} (\emph{10}), pp 2054-2064.
\href{http://doi.org/10.1002/pro.5560071002}{DOI: 10.1002/pro.5560071002}
\href{http://www.ncbi.nlm.nih.gov/pubmed/9792092}{PMID: 9792092}
\href{http://www.kuhnlab.bmb.msu.edu/software/watch/index.html}{WatCH webpage}
}
\seealso{
Other "Bound Water Environment": \code{\link{BoundWaterEnvironment.interact}},
  \code{\link{BoundWaterEnvironment.quality}},
  \code{\link{BoundWaterEnvironment}},
  \code{\link{Mobility}}, \code{\link{NormalizedBvalue}},
  \code{\link{calcBvalue}},
  \code{\link{calcNumHydrogenBonds}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"Bound Water Environment"}
