% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{StandardizeAsparticAcidNames}
\alias{StandardizeAsparticAcidNames}
\title{Standardize Aspartic Acid Names}
\usage{
StandardizeAsparticAcidNames(residue.names)
}
\arguments{
\item{residue.names}{A vector of strings containing the three-letter residue
names (strings)}
}
\value{
vector of three-letter residue names with \emph{standardized}
aspartic acid residue names
}
\description{
Standardize the protonated aspartic acid three-letter residue
name to ASP.
}
\details{
The the protonated aspartic acid three-letter residue name (ASH) is
converted to the standard "ASP" residue name. This function is part of the
\code{\link[=aaStandardizeNames]{aaStandardizeNames()}}.

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
  residue.names <- c("HIS", "HID", "HIE", "HIP", "HSD", "HSE", "HSP",
                     "CYS", "CYM", "CYX", "ASP", "ASH", "GLU", "GLH",
                     "LYS", "LYN")
  StandardizeAsparticAcidNames(residue.names)
  # [1] "HIS" "HID" "HIE" "HIP" "HSD" "HSE" "HSP" "CYS" "CYM" "CYX"
  #     "ASP" "ASP" "GLU" "GLH" "LYS" "LYN"
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{utilities}
