% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HydrophilicityTable_documentation.R
\name{HydrophilicityTable}
\alias{HydrophilicityTable}
\title{Residue Atom Type Hydrophilicity Values}
\description{
Atomic hydrophilicity values for the 20 naturally occurring
amino acids and water.
}
\details{
The Hydrophilicity Table is based on the work of Esposito (see
reference below) in \link{vanddraabe} package. The hydrophilicity values are
based on information from a 1995 analysis of published PDB structures and
indicate how likely the individual atoms of the amino acid residues are to
have a water molecule within 4.0 angstroms.

The data contained within the Hydrophilicity Table is based on ~7900
experimentally determined crystallographic protein structures with
resolution values less than or equal to x.x Angstroms, a R-factor less than
or equal to 0.26, and 20 or more bound waters each. The protein structures
are from the Top8000 ("a database of about 8000 high-resolution,
quality-filtered protein chains"; reference below) high quality protein
dataset from the \href{http://kinemage.biochem.duke.edu}{Kinemage laboratory} at
Duke University. The included structures had a range of B-values and
occupancy values.

These values are based on the methods and protocols of Kuhn \emph{et al}.

The Hydrophilicity Table contains:
\itemize{
\item \strong{residueAtomName}: Contracted residue type and atom name to aid
looking up hydrophilicity values.
\item \strong{residue}: Three-letter residue name.
\item \strong{atomName}: Atom name indicating the atom type and its position in
the amino acid residue.
\item \strong{surfaceOccurrences}: Number of times each
atom has a defined solvent exposed surface area.
\item \strong{hydratOccurrences}: Proportion of the solvent exposed residue-specific
atom type with a water molecule closely bound (within 4.0 Angstroms).
}
}
\references{
Leslie A Kuhn, Craig A Swanson, Michael E Pique, John A Tainer,
and Elizabeth D Getzof. Atomic and Residue Hydrophilicity in the Context of
Folded Protein Structures. \emph{PROTEINS: Structure, Function, and
Genetics}, 1995, \strong{23} (\emph{4}), pp 536-547.
\href{http://doi.org/10.1002/prot.340230408}{DOI: 10.1002/prot.340230408}
\href{http://www.ncbi.nlm.nih.gov/pubmed/8749849}{PMID: 8749849}

Bradley J Hintze, Steven M Lewis, Jane S Richardson, and David C
Richardson. Molprobity's ultimate rotamer-library distributions for model
validation. \emph{Proteins: Structure, Function, and Bioinformatics}, 2016,
\strong{84} (\emph{9}), pp 1177-1189.
\href{https://dx.doi.org/10.1002/prot.25039}{DOI: 10.1002/prot.25039}
\href{http://kinemage.biochem.duke.edu/databases/top8000.php}{Top8000 webpage}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
