% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundWaterEnvironments.R
\name{BoundWaterEnvironment.quality}
\alias{BoundWaterEnvironment.quality}
\title{Bound Water Environment (atomic quality)}
\usage{
BoundWaterEnvironment.quality(distances, set.oi.idc, structure,
  radius = 3.6)
}
\arguments{
\item{distances}{Matrix of atomic pairwise distances}

\item{set.oi.idc}{Indices of atoms of interest; can be protein, water, or
HETATMs if those are of interest}

\item{structure}{The protein structure of interest with its residue and atom
names; X, Y, and Z coordinates; residue and atom numbers; and B-value,
Normalized B-value, Occupancy, and Mobility values.}

\item{radius}{Distance in Angstroms between the atoms of interest; default:
3.6 Angstroms}
}
\value{
A list of the bound water environment values for nearby heavy atoms.
\itemize{
\item \strong{o.sum}: sum of occupancy values
\item \strong{o.mu}: mean of occupancy values
\item \strong{o.sd}: standard deviation of occupancy values
\item \strong{b.exp.sum}: sum of experimental B-values
\item \strong{b.exp.mu}: mean of experimental B-values
\item \strong{b.exp.sd}: standard deviation of experimental B-values
\item \strong{mobility.sum}: sum of mobility values
\item \strong{mobility.mu}: mean of mobility values
\item \strong{mobility.sd}: standard deviation of mobility values
\item \strong{nBvalue.sum}: sum of normalized B-values
\item \strong{nBvalue.mu}: mean of normalized B-values
\item \strong{nBvalue.sd}: standard deviation of normalized B-values
}
}
\description{
Various enviroment counts for bound waters.
}
\details{
For the heavy atoms near each water molecule (oxygen atom) the bound
water environment is calculated. These values are defined in the \strong{Return}
section. The default radius distance is 3.6 Angstroms. While it is possible
to define the radius to a value other than 3.6 this value is hardcoded into
the \code{\link[=ConservedWaters]{ConservedWaters()}} function. This might change in future versions.

\emph{\strong{NOTE}}: This function is designed to work with \code{\link[=ConservedWaters]{ConservedWaters()}} via
the \code{\link[base:apply]{base::apply()}} function processing rows (the \code{MARGIN = 1} option). For
this reason it is \strong{NOT} a public function. The \code{\link[=Nearby]{Nearby()}} is specifically
designed to work with this function.
}
\examples{
  \dontrun{
  distances <- PDB.1hai.h2o.prot.dists[3, ]
  set.oi.idc <- prot.idc
  structure <- PDB.1hai.aoi.clean
  BoundWaterEnvironment.quality(distances,
                                set.oi.idc,
                                structure,
                                radius = 3.6)
  }

}
\references{
Paul C Sanschagrin and Leslie A Kuhn. Cluster analysis of
consensus water sites in thrombin and trypsin shows conservation between
serine proteases and contributions to ligand specificity. \emph{Protein
Science}, 1998, \strong{7} (\emph{10}), pp 2054-2064.
\href{http://doi.org/10.1002/pro.5560071002}{DOI: 10.1002/pro.5560071002}
\href{http://www.ncbi.nlm.nih.gov/pubmed/9792092}{PMID: 9792092}
\href{http://www.kuhnlab.bmb.msu.edu/software/watch/index.html}{WatCH webpage}

Leslie A Kuhn, Craig A Swanson, Michael E Pique, John A Tainer,
and Elizabeth D Getzof. Atomic and Residue Hydrophilicity in the Context of
Folded Protein Structures. \emph{PROTEINS: Structure, Function, and
Genetics}, 1995, \strong{2} (\emph{4}), pp 536-547.
\href{http://doi.org/10.1002/prot.340230408}{DOI: 10.1002/prot.340230408}
\href{http://www.ncbi.nlm.nih.gov/pubmed/8749849}{PMID: 8749849}
}
\seealso{
Other "Bound Water Environment": \code{\link{BoundWaterEnvironment.interact}},
  \code{\link{BoundWaterEnvironment}},
  \code{\link{Mobility}}, \code{\link{NormalizedBvalue}},
  \code{\link{calcBvalue}},
  \code{\link{calcNearbyHydrationFraction}},
  \code{\link{calcNumHydrogenBonds}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"Bound Water Environment"}
