% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMGLLF.R
\name{EMGLLF}
\alias{EMGLLF}
\title{EMGLLF}
\usage{
EMGLLF(
  phiInit,
  rhoInit,
  piInit,
  gamInit,
  mini,
  maxi,
  gamma,
  lambda,
  X,
  Y,
  eps,
  fast
)
}
\arguments{
\item{phiInit}{an initialization for phi}

\item{rhoInit}{an initialization for rho}

\item{piInit}{an initialization for pi}

\item{gamInit}{initialization for the a posteriori probabilities}

\item{mini}{integer, minimum number of iterations in the EM algorithm, by default = 10}

\item{maxi}{integer, maximum number of iterations in the EM algorithm, by default = 100}

\item{gamma}{integer for the power in the penaly, by default = 1}

\item{lambda}{regularization parameter in the Lasso estimation}

\item{X}{matrix of covariates (of size n*p)}

\item{Y}{matrix of responses (of size n*m)}

\item{eps}{real, threshold to say the EM algorithm converges, by default = 1e-4}

\item{fast}{boolean to enable or not the C function call}
}
\value{
A list (corresponding to the model collection) defined by (phi,rho,pi,llh,S,affec):
  phi : regression mean for each cluster, an array of size p*m*k
  rho : variance (homothetic) for each cluster, an array of size m*m*k
  pi : proportion for each cluster, a vector of size k
  llh : log likelihood with respect to the training set
  S : selected variables indexes, an array of size p*m*k
  affec : cluster affectation for each observation (of the training set)
}
\description{
Run a generalized EM algorithm developped for mixture of Gaussian regression
models with variable selection by an extension of the Lasso estimator (regularization parameter lambda).
Reparametrization is done to ensure invariance by homothetic transformation.
It returns a collection of models, varying the number of clusters and the sparsity in the regression mean.
}
