% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_glyph.r
\name{bed_glyph}
\alias{bed_glyph}
\title{Create example glyphs for valr functions.}
\usage{
bed_glyph(expr, label = NULL, res_name = "result")
}
\arguments{
\item{expr}{expression to evaluate}

\item{label}{col name for label output}

\item{res_name}{name of result in output}
}
\value{
\code{ggplot}
}
\description{
Create example glyphs for valr functions.
}
\examples{
x <- tibble::tribble(
 ~chrom, ~start, ~end,
 'chr1', 25,     50,
 'chr1', 100,    125
)

y <- tibble::tribble(
  ~chrom, ~start, ~end, ~value,
  'chr1', 30,     75,  50
)

bed_glyph(bed_intersect(x, y))

x <- tibble::tribble(
  ~chrom, ~start, ~end,
  'chr1', 30,     75,
  'chr1', 50,     90,
  'chr1', 91,     120
)

bed_glyph(bed_merge(x))

bed_glyph(bed_cluster(x), label = '.id')

}

