% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_absdist.r
\name{bed_absdist}
\alias{bed_absdist}
\title{Compute absolute distances between intervals.}
\usage{
bed_absdist(x, y, genome)
}
\arguments{
\item{x}{tbl of intervals}

\item{y}{tbl of intervals}

\item{genome}{genome tbl}
}
\value{
\code{data_frame} with \code{.absdist} and \code{.absdist_scaled}
  columns.
}
\description{
Compute absolute distances between intervals.
}
\details{
\code{bed_absdist()} computes the absolute distance between the 
  midpoint of query intervals and the closest midpoints of a set of reference
  intervals.
  
  Absolute distances are scaled by the inter-reference gap for the chromosome
  as follows. For \code{Q} total query points and \code{R} reference points
  on a chromosome, scale the distance for each query point \code{i} to the
  closest reference point by the inter-reference gap for each chromosome. If
  the chromosome for a supplied  \code{x} interval has no matching  \code{y}
  chromosome, the \code{absdist} will be reported as an \code{NA}.
  
  \deqn{d_i(x,y) = min_k(|q_i - r_k|)\frac{R}{Length\ of\ chromosome}}
  
  By default both absolute and scaled distances are reported as \code{.absdist} and
  \code{.absdist_scaled} respectively.
}
\examples{
x <- tibble::frame_data(
~chrom,   ~start,    ~end,
"chr1",    75,       125
  )

y <- tibble::frame_data(
  ~chrom,   ~start,    ~end,
  "chr1",    50,       100,
  "chr1",    100,       150
  )
  
genome <- tibble::frame_data(
  ~chrom, ~size,
  "chr1", 500,
  "chr2", 1000
)

bed_absdist(x, y, genome)

}
\seealso{
\url{http://journals.plos.org/ploscompbiol/article?id=10.1371/journal.pcbi.1002529}

Other interval-stats: \code{\link{bed_fisher}},
  \code{\link{bed_jaccard}}, \code{\link{bed_projection}},
  \code{\link{bed_reldist}}
}

