% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confrontation.R
\docType{methods}
\name{event}
\alias{event}
\alias{event<-}
\alias{event,confrontation-method}
\alias{event<-,confrontation-method}
\title{Get or set event information metadata from a 'confrontation' object.}
\usage{
event(x)

event(x) <- value

\S4method{event}{confrontation}(x)

\S4method{event}{confrontation}(x) <- value
}
\arguments{
\item{x}{an object of class \code{confrontation}}

\item{value}{\code{[character]} vector of length 4 with event identifiers.}
}
\value{
A a character vector with elements
  \code{"agent"}, which defaults to the R version and platform returned by
  \code{R.version}, a timestamp (\code{"time"})  in ISO 8601 format and a
  \code{"actor"} which is the user name returned by \code{Sys.info()}. The
  last element is called \code{"trigger"} (default \code{NA_character_}), which
  can be used to administrate the event that triggered the confrontation.
}
\description{
The purpose of event information is to store information that allows for
identification of the confronting event.
}
\examples{
data(retailers)
rules <- validator(turnover >= 0, staff >=0)
cf <- confront(retailers, rules)
event(cf)

# adapt event information
u <- event(cf)
u["trigger"] <- "spontaneous validation"
event(cf) <- u
event(cf)

}
\references{
Mark van der Loo and Olav ten Bosch (2017) 
\href{https://goo.gl/hEGdbo}{Design of a generic machine-readable validation report structure}, 
version 1.0.0.
}
\seealso{
Other confrontation-methods: \code{\link{[,expressionset-method}},
  \code{\link{as.data.frame,confrontation-method}},
  \code{\link{confrontation-class}},
  \code{\link{confront}}, \code{\link{errors}},
  \code{\link{keyset}},
  \code{\link{length,expressionset-method}},
  \code{\link{values}}

Other validation-methods: \code{\link{aggregate,validation-method}},
  \code{\link{all,validation-method}},
  \code{\link{any,validation-method}},
  \code{\link{barplot,validation-method}},
  \code{\link{check_that}}, \code{\link{compare}},
  \code{\link{confront}},
  \code{\link{plot,validation-method}},
  \code{\link{sort,validation-method}},
  \code{\link{summary}}, \code{\link{validation-class}},
  \code{\link{values}}

Other indication-methods: \code{\link{confront}},
  \code{\link{indication-class}}, \code{\link{summary}}
}
\concept{confrontation-methods}
\concept{indication-methods}
\concept{validation-methods}
