% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{\%vin\%}
\alias{\%vin\%}
\title{A consistent set membership operator}
\usage{
x \%vin\% table
}
\arguments{
\item{x}{vector or \code{NULL}: the values to be matched}

\item{table}{vector or \code{NULL}: the values to be matched against.}
}
\description{
A membership operator like \code{\link[base:match]{\%in\%}} that handles
\code{NA} more consistently with R's other logical comparison operators.
}
\note{
R's basic comparison operators (almost) always return \code{NA} when one 
of the operands is \code{NA}. The \code{\%in\%} operator is an exception.
Compare for example \code{NA \%in\% NA} with \code{NA == NA}.
}
\examples{
# we cannot be sure about the first element:
c(NA, "a") \%vin\% c("a","b")

# we cannot be sure about the 2nd and 3rd element (but note that they
# cannot both be TRUE):
c("a","b","c") \%vin\% c("a",NA)

# we can be sure about all elements:
c("a","b") \%in\% character(0)

}
