% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_rdbr.R
\name{predict.RDBRmodel}
\alias{predict.RDBRmodel}
\title{Predict Method for RDBR}
\usage{
\method{predict}{RDBRmodel}(object, newdata, estimative = NULL,
  max.iterations = 5, batch.mode = FALSE,
  probability = getOption("utiml.use.probs", TRUE), ...,
  cores = getOption("utiml.cores", 1), seed = getOption("utiml.seed",
  NA))
}
\arguments{
\item{object}{Object of class '\code{RDBRmodel}'.}

\item{newdata}{An object containing the new input data. This must be a
matrix, data.frame or a mldr object.}

\item{estimative}{A matrix containing the bipartition result of other
multi-label classification algorithm or an mlresult object with the
predictions.}

\item{max.iterations}{The maximum allowed iterations of the RDBR technique.
(Default: 5)}

\item{batch.mode}{Logical value to determine if use the batch re-estimation.
If \code{FALSE} then use the stochastic re-estimation strategy.
(Default: \code{FALSE})}

\item{probability}{Logical indicating whether class probabilities should be
returned. (Default: \code{getOption("utiml.use.probs", TRUE)})}

\item{...}{Others arguments passed to the base algorithm prediction for all
subproblems.}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of type mlresult, based on the parameter probability.
}
\description{
This function predicts values based upon a model trained by \code{rdbr}.
In general this method is a recursive version of
\code{\link{predict.DBRmodel}}.
}
\details{
Two versions of the update strategy of the estimated labels are implemented.
The batch re-estimates the labels only when a complete current label vector
is available. The stochastic uses re-estimated labels as soon as they become
available. This second does not support parallelize the prediction, however
stabilizes earlier than batch mode.
}
\examples{
\dontrun{
# Predict SVM scores
model <- rdbr(toyml)
pred <- predict(model, toyml)

# Passing a specif parameter for SVM predict algorithm
pred <- predict(model, toyml, na.action = na.fail)

# Use the batch mode and increase the max number of iteration to 10
pred <- predict(model, toyml, max.iterations = 10, batch.mode = TRUE)

# Using other classifier (EBR) to made the labels estimatives
estimative <- predict(ebr(toyml), toyml, probability = FALSE)
model <- rdbr(toyml, estimate.models = FALSE)
pred <- predict(model, toyml, estimative = estimative)
}
}
\references{
Rauber, T. W., Mello, L. H., Rocha, V. F., Luchi, D., & Varejao, F. M.
  (2014). Recursive Dependent Binary Relevance Model for Multi-label
  Classification. In Advances in Artificial Intelligence - IBERAMIA, 206-217.
}
\seealso{
\code{\link[=rdbr]{Recursive Dependent Binary Relevance (RDBR)}}
}
