% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HigherOrderRiskPreferences.R
\name{compute_measures_aux}
\alias{compute_measures_aux}
\title{Given a set of smooth and continuous functions, computes predefined and user-defined measures.}
\usage{
compute_measures_aux(
  x_grids,
  coeffs,
  ids,
  ndx = 20,
  deg = 6,
  measures = c("risk-arrow-pratt", "crainich-eeckhoudt", "denuit-eeckhoudt"),
  ...
)
}
\arguments{
\item{x_grids}{a dataframe of vectors of x-values for a smooth and continuous function.}

\item{coeffs}{a dataframe of coefficients for a smooth and continuous function for each participant.}

\item{ids}{a list containing the IDs of the participants. If not given, a list with IDs from 1 to n_observations will be created.}

\item{ndx}{number of intervals to partition the distance between the lowest and highest x-values of the utility points.}

\item{deg}{degree of the B-spline basis. Determines the degree of the function to be estimated. If deg = 2, the estimated utility function will consist of quadratic functions.}

\item{measures}{a vector of measures to be computed.}

\item{...}{additional parameters for user-defined measures.}
}
\value{
A set of measurements.
}
\description{
Given a set of smooth and continuous functions, computes predefined and user-defined measures.
}
\keyword{internal}
