% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{paste}
\alias{paste}
\alias{paste0}
\title{Concatenate strings}
\usage{
paste(..., sep = " ", collapse = NULL, na.rm = FALSE)

paste0(..., collapse = NULL, na.rm = FALSE)
}
\arguments{
\item{...}{R objects to be converted to character vectors.}

\item{sep}{A character. A string to separate the terms.}

\item{collapse}{A character. An string to separate the results.}

\item{na.rm}{A logical. Whether to remove NA values from 'x'.
Note that NA values are also removed from vectors.}
}
\value{
Character vector of concatenated values.
}
\description{
An augmented version of \code{\link[base:paste]{base::paste()}} with options to
manage NA values.
}
\details{
The \code{\link[base:paste]{base::paste()}} function is intentionally
designed to coarce NA values to characters that appear in the concatenated
character output. This behavior is not always desirable (i.e. when programatically
calling paste) and there is currently no means of opting out of this behavior.
These augmented functions address this deficit.
}
\examples{
# Base paste() NA handling behavior
paste(
  'The', c('red', NA, 'orange'), 'fox jumped', NA, 'over the fence.',
  collapse = ' '
)

# Removal of NA values
paste(
  'The', c('red', NA, 'orange'), 'fox jumped', NA, 'over the fence.',
  collapse = ' ',
  na.rm = TRUE
)
}
\seealso{
\code{\link[base]{paste}}
}
