% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upmrun.R
\name{upmrun}
\alias{upmrun}
\title{Bayesian Markov Chain Monte Carlo model building for household-community tuberculosis transmission models}
\usage{
upmrun(design.matrix, categorical.columns = 0, prior.beta.means = rep(x = 0,
  times = ncol(design.matrix[, which(names(design.matrix) != "cluster")])),
  prior.beta.sd = rep(x = 3.162278, times = ncol(design.matrix[,
  which(names(design.matrix) != "cluster")])), prior.alpha = c(0, 0.44),
  n.chains = 3, n.iter = 50000, n.burnin = n.iter/2, n.thin = max(1,
  floor((n.iter - n.burnin)/1000)))
}
\arguments{
\item{design.matrix}{A data frame type design matrix of observations for rows, variables on each observation for columns. If there are natural clusters (households), then a variable titled 'cluster' must be included. The design matrix must have exactly one column titled 'y' for outcome on each observation and at least one column of predictors.}

\item{categorical.columns}{A scalar (vector) specification of any column(s) of type 'factor' to be coded as a dummy variable regression. Default is 0: no columns are factor variables.}

\item{prior.beta.means}{A scalar (vector) specification of Gaussian prior distirbution mean(s) for the coefficient(s) in the household component of the logistic regression model. Default is noninformative on the inverse logit transformed (odds ratio) scale.}

\item{prior.beta.sd}{A scalar (vector) specification of Gaussian prior distirbution standard deviation(s) for the coefficient(s) in the household component of the logistic regression model.  Default is noninformative on the inverse logit transformed (odds ratio) scale.}

\item{prior.alpha}{A vector of prior probability parameters for the alpha term in the community component of model, a logistic regression with intercept only. Default is noninformative, with p^C being essentially uniform on the unit interval.}

\item{n.chains}{From JAGS documentation: number of Markov chains (default: 3).}

\item{n.iter}{From JAGS documentation: number of total iterations per chain (including burn in; JAGS default is 2000, updated here to 50000).}

\item{n.burnin}{From JAGS documentation: length of burn in, i.e. number of iterations to discard at the beginning. Default is n.iter/2, that is, discarding the first half of the simulations. If n.burnin is 0, jags() will run 100 iterations for adaption.}

\item{n.thin}{From JAGS documentation: thinning rate. Must be a positive integer. Set n.thin > 1 to save memory and computation time if n.iter is large. Default is max(1, floor(n.chains * (n.iter-n.burnin) / 1000)) which will only thin if there are at least 2000 simulations.}
}
\value{
Returns a JAGS object of posterior samples for: household predictors (betas); if clusters are present, the posterior distribution of the hierarchical effects mean and standard deviation; the probability of community-acquired infection (post.comm.risk); the probability of household-acquired infection (pHHinfection); and model deviance.
}
\description{
Bayesian Markov Chain Monte Carlo model building for household-community tuberculosis transmission models
}
\details{
The package contains long-form documentation in the form of a vignette that cover the use of the main fucntions. Use browseVignettes(package="upmfit") to access them.
}
\examples{
upmrun(design.matrix=upmdata, n.iter=100, prior.alpha = c(-2.2, 1/sqrt(3)))

}
