% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multidog.R
\name{filter_snp}
\alias{filter_snp}
\title{Filter SNPs based on the output of \code{\link{multidog}()}.}
\usage{
filter_snp(x, expr)
}
\arguments{
\item{x}{The output of \code{multidog}.}

\item{expr}{Logical predicate expression defined in terms of the variables
in \code{x$snpdf}. Only SNPs where the condition evaluates to
\code{TRUE} are kept.}
}
\description{
Filter based on provided logical predicates in terms of the variable
names in \code{x$snpdf}. This function filters both \code{x$snpdf}
and \code{x$inddf}.
}
\examples{
\dontrun{
data("uitdewilligen")
mout <- multidog(refmat = t(uitdewilligen$refmat),
                 sizemat = t(uitdewilligen$sizemat),
                 ploidy = uitdewilligen$ploidy,
                 nc = 2)

## The following filters are for educational purposes only and should
## not be taken as a default filter:
mout2 <- filter_snp(mout, bias < 0.8 & od < 0.003)
}

}
\seealso{
\itemize{
  \item{\code{\link{multidog}()}:}{For the variables in \code{x$snpdf}
      which you can filter by.}
}
}
\author{
David Gerard
}
