% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_red.R
\name{update_dr}
\alias{update_dr}
\title{Same as \code{\link{update_pp_f1}} but I exclusively use the EM (instead of also Brent's method),
and I allow for priors on the mixing proportions.}
\usage{
update_dr(weight_vec, model = c("f1pp", "f1ppdr"), control)
}
\arguments{
\item{weight_vec}{\code{colSums(wik_mat)} from \code{\link{flexdog}}.
This is the sum of current posterior probabilities of each individual
having genotype k.}

\item{model}{The model to assume.}

\item{control}{A list of anything else needed to be passed.
E.g. if \code{model = "ash"},
then \code{inner_weights} needs to be passed through \code{control}
(see \code{\link{get_inner_weights}} for how to get this matrix).}
}
\value{
A list with the following elements:
\describe{
\item{\code{p1_pair_weights}}{A list with the mixing weights for the
    bivalent components of parent 1.}
\item{\code{p2_pair_weights}}{A list with the mixing weights for the
    bivalent components of parent 2.}
\item{\code{obj}}{The maximized objective.}
\item{\code{p1geno}}{The estimated genotype for parent 1.}
\item{\code{p2geno}}{The estimated genotype for parent 2.}
\item{\code{pivec}}{The estimated genotype distribution for the
    offspring.}
}
}
\description{
Same as \code{\link{update_pp_f1}} but I exclusively use the EM (instead of also Brent's method),
and I allow for priors on the mixing proportions.
}
\seealso{
\code{\link{update_pp_f1}}
}
