% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectify.R
\name{rectify}
\alias{rectify}
\alias{print.cell_grid}
\title{Display cells as though in a spreadsheet}
\usage{
rectify(cells, values = NULL, types = data_type, formatters = list())

\method{print}{cell_grid}(x, display = "terminal", ...)
}
\arguments{
\item{cells}{Data frame or tbl, the cells to be displayed.}

\item{values}{Optional. The column of \code{cells} to use as the values of each
cell.  Given as a bare variable name.  If omitted (the default), the \code{types}
argument will be used instead.}

\item{types}{The column of \code{cells} that names, for each cell, which column to
use for the value of the cell.  E.g.  a cell with a character value will have
\code{"character"} in this column.}

\item{formatters}{A named list of functions to format cell values for
display, named according to the column that the cell value is in.}

\item{x}{The output of \code{\link[=rectify]{rectify()}}}

\item{display}{One of \code{"terminal"} (default), \code{"browser"}, \code{"rstudio"}.  To
display in the browser you must have the \code{DT} package installed.}

\item{...}{Arguments passed on to \code{\link[=print]{print()}}}
}
\description{
Takes the 'melted' output of \code{as_cells()} or
\code{tidyxl::xlsx_cells()} (each row represents one cell) and projects the cells
into their original positions.  By default this prints to the
terminal/console, but with \code{display = "browser"} or \code{display = "rstudio"} it
will be displayed in the browser or the RStudio viewer pane.

This is for viewing only; the output is not designed to be used in other
functions.

Example: The following cells

\if{html}{\out{<div class="sourceCode">}}\preformatted{row col value
  1   1   "a"
  1   2   "b"
  2   1   "c"
  2   2   "d"
}\if{html}{\out{</div>}}

Would be presented as

\if{html}{\out{<div class="sourceCode">}}\preformatted{row/col 1(A) 2(B)
      1 "a"  "b"
      2 "c"  "d"
}\if{html}{\out{</div>}}

The letters in the column names are for comparing this view with a
spreadsheet application.
}
\section{Functions}{
\itemize{
\item \code{print(cell_grid)}: S3 method for class \code{cell_grid}

}}
\examples{
x <- data.frame(name = c("Matilda", "Nicholas"),
                score = c(14L, 10L),
                stringsAsFactors = FALSE)

# This is the original form of the table, which is easy to read.
x

# This is the 'tidy' arrangement that is difficult for humans to read (but
# easy for computers)
y <- as_cells(x, col_names = TRUE)
y

# rectify() projects the cells as a spreadsheet again, for humans to read.
rectify(y)

# You can choose to use a particular column of the data
rectify(y, values = chr)
rectify(y, values = int)

# You can also show which row or which column each cell came from, which
# helps with understanding what this function does.
rectify(y, values = row)
rectify(y, values = col)

# Empty rows and columns up to the first occupied cell are dropped, but the
# row and column names reflect the original row and column numbers.
y$row <- y$row + 5
y$col <- y$col + 5
rectify(y)

# Supply named functions to format cell values for display.
rectify(y, formatters = list(chr = toupper, int = ~ . * 10))
#
# Print in the browser or in the RStudio viewer pane
\dontrun{
  z <- rectify(y)
  print(z, "browser")
  print(z, "rstudio")
}
}
