## -----------------------------------------------------------------------------
library(unmarked)
set.seed(123)
M <- 300
J <- 8
y <- matrix(NA, M, J)

## -----------------------------------------------------------------------------
site_covs <- data.frame(elev = rnorm(M))

## -----------------------------------------------------------------------------
umf <- unmarkedFrameOccu(y = y, siteCovs = site_covs)
head(umf)

## -----------------------------------------------------------------------------
model <- occu

## -----------------------------------------------------------------------------
form <- ~1~elev

## ----error = TRUE-------------------------------------------------------------
simulate(umf, model = model, formula = form)

## -----------------------------------------------------------------------------
plogis(0)

## -----------------------------------------------------------------------------
cf <- list(state = c(0, -0.4), det = 0)

## -----------------------------------------------------------------------------
out <- simulate(umf, model = occu, formula = ~1~elev, coefs = cf)

## -----------------------------------------------------------------------------
head(out[[1]])

## -----------------------------------------------------------------------------
occu(~1~elev, data = out[[1]])

## -----------------------------------------------------------------------------
set.seed(123)
M <- 100
Jdist <- 4
Jrem <- 5

y_dist <- matrix(NA, M, Jdist)
y_rem <- matrix(NA, M, Jrem)

## -----------------------------------------------------------------------------
site_covs <- data.frame(elev = rnorm(M))
obs_covs <- data.frame(wind = rnorm(M * Jrem))

## -----------------------------------------------------------------------------
umf <- unmarkedFrameGDR(yRem = y_rem, yDist = y_dist, siteCovs = site_covs, obsCovs = obs_covs,
                        dist.breaks = c(0,25,50,75,100), unitsIn = 'm')

## -----------------------------------------------------------------------------
head(umf)

## -----------------------------------------------------------------------------
lambdaformula <- ~elev # elevation effect on abundance
removalformula <- ~wind # wind effect on removal p
distanceformula <- ~1
mixture <- "NB"

## ----error=TRUE---------------------------------------------------------------
simulate(umf, lambdaformula=~elev, removalformula=~wind, distanceformula=~1,
         mixture="NB")

## -----------------------------------------------------------------------------
cf <- list(lambda = c(log(5), 0.7),
           dist = log(50),
           alpha = 0.1,
           rem = c(-1, -0.3))

## -----------------------------------------------------------------------------
out <- simulate(umf, lambdaformula=~elev, removalformula=~wind, distanceformula=~1,
                coefs=cf, mixture="NB", nsim=2)

## -----------------------------------------------------------------------------
lapply(out, head)

## -----------------------------------------------------------------------------
gdistremoval(lambdaformula=~elev, removalformula=~wind, distanceformula=~1, data=out[[1]],
             mixture="NB")

