
test.parboot.occu <- function() {

    set.seed(6546)
    R <- 20
    J <- 5
    z <- rbinom(R, 1, 0.6)
    y <- matrix(NA, R, J)
    y[] <- rbinom(R*J, 1, z*0.7)
    x1 <- rnorm(R)
    x2 <- y
    x2[] <- rnorm(R*J)
    x2[1,] <- NA
    x2[3,1] <- NA
    umf <- unmarkedFrameOccu(y=y, siteCovs=data.frame(x1=x1),
                             obsCovs=list(x2=x2))

    fitstats <- function(fm) {
        observed <- getY(fm@data)
        expected <- fitted(fm)
        resids <- residuals(fm)
        sse <- sum(resids^2,na.rm=TRUE)
        chisq <- sum((observed - expected)^2 / expected,na.rm=TRUE)
        freeTuke <- sum((sqrt(observed) - sqrt(expected))^2,na.rm=TRUE)
        out <- c(SSE=sse, Chisq=chisq, freemanTukey=freeTuke)
        return(out)
    }

    x.1 <- "x1"
    x.2 <- "x2"
##    frm.obj <- as.formula(paste("~", x.2, "~", x.1))
    fm1 <- occu(~x2 ~x1, umf)
##    fm2 <- occu(frm.obj, umf)
    gof <- parboot(fm1, fitstats, nsim = 100, seed = 6546)
##    gof2 <- parboot(fm2, fitstats, nsim = 100, seed = 6546)

##    checkEquals(gof@t.star, gof2@t.star)
    ## checkEquals(gof@t.star,
    ##             structure(c(19.5618449798627, 17.4002359377683, 17.9537040353665,
    ##                         21.075371921093, 16.0962042909353, 20.325552699814, 23.7198566870693,
    ##                         19.5108924194316, 19.8642253546241, 21.5327320826537, 21.1187621901383,
    ##                         16.7956032348677, 22.0287240694084, 22.3480005863275, 18.7973008017797,
    ##                         23.1214849443085, 13.3506204184759, 21.5072703730266, 20.4061806452888,
    ##                         14.6052617734126, 18.8706802331149, 13.0708994826577, 20.1372507635082,
    ##                         14.6298678460545, 14.6057681371775, 18.831780320931, 17.120219947307,
    ##                         19.4171670630644, 21.4957335846724, 22.4888402383621, 12.322613247868,
    ##                         21.5454567695879, 14.6852414309207, 19.7838342994475, 17.8245593195829,
    ##                         22.1969431231403, 17.7606626580712, 19.3546579192266, 20.2796878074241,
    ##                         13.1625669588524, 20.1565567700057, 18.4624537665433, 18.7281497995722,
    ##                         17.084276968227, 18.7749912147129, 21.51782846093, 22.7333831188702,
    ##                         16.5775111637824, 18.2032322719839, 22.4139063387728, 15.9946392373616,
    ##                         15.5915117285785, 21.19490854222, 17.827591586556, 21.3012334843756,
    ##                         21.6488943962608, 17.6126714952445, 18.8307613494122, 20.1703098549003,
    ##                         15.1625669579498, 19.826946456208, 15.7205534649991, 20.3656552130317,
    ##                         16.2150934276948, 21.751225967568, 19.1377654709796, 18.4258360327573,
    ##                         21.7833681303917, 21.0655247805897, 21.9629466970292, 16.6242076104607,
    ##                         15.1981816691142, 12.5702905066807, 19.6157287827686, 20.9402336996149,
    ##                         14.7123207579701, 21.4435346035415, 22.203853561449, 19.3693120876226,
    ##                         18.541012442289, 20.8523885801662, 17.5557349612729, 21.1092291315395,
    ##                         15.3409036607707, 22.2534589622124, 19.3384363437181, 13.0019012153355,
    ##                         18.4330918039649, 21.6586617051047, 17.881798324457, 22.6601416905637,
    ##                         18.616287158617, 19.0554188699823, 17.4220384268791, 16.7061405736726,
    ##                         22.6182783715741, 22.1268109325025, 21.9230866316946, 15.2082641262436,
    ##                         18.0812577912096, 43.3811085710622, 45.9748066338993, 53.1267194500903,
    ##                         53.9226412608954, 57.2322853419496, 56.81913797575, 42.843092859435,
    ##                         71.645827922274, 54.9269841336055, 50.0243834249273, 49.4273985801733,
    ##                         43.0939544330471, 55.7119685217531, 55.2558872423902, 47.7870495776912,
    ##                         52.6225653375692, 21.1044790363835, 60.7708658750924, 59.9864660260814,
    ##                         48.158395289865, 61.7457993539094, 37.0625570895648, 50.1620681411728,
    ##                         107.147790014673, 75.8456014881641, 73.1799441669325, 66.5580949970634,
    ##                         66.5923835657879, 43.2525590763885, 49.6312006043033, 50.1301251225221,
    ##                         52.8556920360704, 52.4751938312775, 56.4790071460586, 36.8647563645067,
    ##                         59.2938627030736, 67.4047022626281, 52.9528060465144, 59.4117890330828,
    ##                         96.5345848217843, 45.0662041888096, 61.9689590696746, 46.7435460147703,
    ##                         66.1761660198351, 52.9320582824706, 61.4889836317416, 55.9574703456775,
    ##                         37.8266167880213, 96.8599350204107, 69.2816343189622, 47.3277238738376,
    ##                         42.3484674062992, 56.7952852409591, 65.6088755086021, 58.8365068950566,
    ##                         48.1777438550257, 57.793775564308, 77.6740293003584, 68.5207148634468,
    ##                         62.0601548039289, 59.0183338904649, 62.2703649855977, 49.8261111448057,
    ##                         64.8256636904662, 48.3927867616504, 61.4841796026201, 73.88006108371,
    ##                         51.8816936520876, 48.5461720712801, 56.9866166106678, 69.3993834402648,
    ##                         54.8704280205806, 53.7461657636567, 67.1426253749932, 59.4522997378742,
    ##                         53.9775639251258, 51.8880881698028, 46.7652137312378, 54.7160400929552,
    ##                         82.1622240570002, 63.4847263649612, 48.2103917727117, 55.0178942648036,
    ##                         55.6473439310099, 54.3938693100806, 71.9583575909036, 85.4748087238452,
    ##                         73.3103805543379, 67.6745322247688, 46.5483213094101, 62.9901631672752,
    ##                         66.978261744477, 68.6352895991559, 36.229360963399, 65.2150267164381,
    ##                         50.5686157431811, 55.6084482038548, 52.2075884629467, 38.1507417643389,
    ##                         53.4129283520586, 23.2664577864302, 21.0750583945179, 22.6262152397489,
    ##                         26.0567150448873, 20.4403218751078, 25.7594470302298, 26.5121247843041,
    ##                         24.209733661715, 24.9785133948159, 25.5169785617333, 24.9847874670303,
    ##                         20.1061010934685, 26.9129640852366, 26.5874571048698, 22.8912318274687,
    ##                         27.262379925334, 14.9143114366755, 25.8352685143758, 24.6913130913828,
    ##                         18.237633777394, 23.8829720420229, 15.5867212282945, 24.7824806665662,
    ##                         19.620841205235, 19.2916899251373, 22.839576313349, 21.7274734394576,
    ##                         22.2922040497901, 25.2604485627385, 26.5400357020065, 16.1731884602148,
    ##                         26.1384672346904, 17.5893536807727, 24.5020407308938, 21.8260195910276,
    ##                         27.1746057194612, 23.3287029690398, 23.5276963545107, 24.8954041928928,
    ##                         18.4758269380415, 23.5954906760685, 21.6370332727459, 23.0349712484037,
    ##                         22.2194937217677, 23.1543976924809, 25.8737217459936, 27.8513283250486,
    ##                         19.6965071514396, 23.0268570741737, 28.0677719124672, 19.8840377834397,
    ##                         18.4603389863306, 25.8298086845132, 23.2485637347826, 25.9168966206968,
    ##                         26.1887756301694, 22.0435838347155, 22.4088635238283, 24.4074264892885,
    ##                         20.8130191441585, 23.961059426556, 19.9071500178624, 24.9198338755164,
    ##                         20.3318469099804, 25.7014219567935, 23.1867285598034, 23.6312172996782,
    ##                         26.0231017648937, 25.5379206389201, 26.930788231955, 22.4731473297016,
    ##                         20.2329929484612, 16.6778609896376, 25.1297713236246, 26.5495503537427,
    ##                         18.9205151612852, 26.2004914124675, 25.9815529035957, 23.9187162955908,
    ##                         23.4859888111333, 26.7429680608443, 20.9712900937786, 25.9103649128181,
    ##                         19.4568163614539, 27.2478522089053, 24.8188282021128, 17.6645199950128,
    ##                         23.0689346700379, 26.9644431478494, 21.2922969391002, 27.1491334558255,
    ##                         24.3752059401432, 23.4504323299462, 20.5969557152295, 21.8180949333664,
    ##                         26.4219322965689, 26.974047815842, 26.5215425452644, 18.5907018551572,
    ##                         22.1663811466474), .Dim = c(100L, 3L),
    ##                       .Dimnames = list(NULL, c("SSE", "Chisq", "freemanTukey"))))
    checkEquals(gof@t.star,
                structure(c(22.7233928126168, 12.3470513091314, 23.7920502079817,
                            17.562548865536, 15.8274704541987, 21.5149949042608, 18.3364213295809,
                            19.5370792522799, 23.3002776112391, 22.1362628199284, 15.5854689339351,
                            15.1277395349963, 18.3828771510762, 22.7128385736052, 21.6013417065336,
                            14.3137001062674, 13.6651731460017, 21.6375475753657, 15.7936523110773,
                            16.8864270821705, 18.9557142685823, 17.6410490820112, 18.8131612569099,
                            21.0904192210448, 14.1182286468629, 17.013562616852, 21.163360860191,
                            16.0843700107381, 15.2633690023902, 21.3433906372418, 20.3900662174045,
                            17.2265724981855, 21.0456502431369, 18.0145390375389, 17.3831729415441,
                            20.5665443766834, 20.0672720633256, 18.0453886074926, 21.0176570830052,
                            20.3827441604234, 21.0531219967315, 13.8616751536837, 15.4777345180738,
                            23.2686021615517, 23.0803566363563, 20.1668559314916, 18.1790476763143,
                            17.0808510218274, 20.9444696275573, 20.7770892589072, 16.7109124021832,
                            18.3580675455657, 23.1930009936209, 23.8538143094007, 16.4582665354875,
                            19.2105974920747, 20.6643012214347, 15.7059047130661, 19.6969525827628,
                            17.5145881975532, 19.7590963063933, 23.537571869555, 22.9734087595291,
                            20.6947496339553, 21.9336725495054, 21.0217473764709, 18.15479864132,
                            20.7988926386094, 21.6512172560475, 18.0121784351756, 17.8236150782961,
                            15.5070684019809, 20.3188438391569, 17.1075881178638, 23.7649112442344,
                            22.0149403215063, 18.5589400451582, 11.4130400689746, 20.7516976527603,
                            17.4614212961767, 16.3050943716475, 21.4406768816817, 19.2358057749613,
                            19.961294492026, 14.3583983338228, 21.2999444426061, 23.0397634096146,
                            15.7797191967604, 20.011304627921, 20.9613288539077, 15.7796545713692,
                            17.2676354147528, 19.4461769440979, 18.2818574582096, 18.0707416986471,
                            21.4992608963319, 22.3955981128822, 19.1835491436784, 18.9893496511941,
                            18.7382918257025, 51.9856971536444, 67.6102228126359, 48.7007259828727,
                            70.9696425175052, 75.6800614962169, 50.6393909710163, 70.0866005875347,
                            59.7006460060852, 50.9062463644471, 53.9952051410813, 75.4755013878626,
                            58.0792954269582, 64.546059885491, 55.6780355721395, 60.3773404549984,
                            52.6232571181147, 58.7713242147682, 55.5244499485268, 76.7403389716958,
                            74.4397251021063, 61.2808408559695, 73.4805893712095, 67.5985215079632,
                            55.8680467132114, 82.8404002665877, 40.9257175582078, 49.1545573345842,
                            76.1290436960065, 62.3342471297642, 58.4881275555864, 61.3015423834998,
                            69.2982774008338, 57.8480331109274, 57.115156714144, 70.5926016143194,
                            64.3089945811578, 64.0454363217668, 73.6342724332328, 63.0973538945623,
                            46.0079724789278, 60.824163178328, 62.3369143375445, 65.7779202012562,
                            50.9838985407446, 55.9649037046276, 65.3059759483931, 61.7048561065541,
                            89.1495239320995, 62.4255191246129, 55.9666371908698, 64.9711553418659,
                            44.7955283204842, 52.7263330734089, 53.0102378378038, 62.7363753573863,
                            65.5108921765033, 51.3104017672061, 74.6738643978355, 61.2377022816563,
                            64.5705758805414, 64.5907138845152, 46.2671394510726, 58.3426749468043,
                            65.3930872961233, 51.7297475883299, 60.9378842164194, 69.4185294997595,
                            62.2320869296418, 58.6755221153412, 69.4755999917795, 51.1751415044348,
                            70.2162397717456, 60.1541293708152, 57.1660465472361, 53.1631075611234,
                            60.1548930528115, 67.6662657363848, 55.579790735032, 38.5975278615509,
                            57.4963623986252, 67.6907061470825, 63.1755612437132, 67.9016192451441,
                            64.900914367349, 56.1793282464025, 63.2304545063742, 58.4474590740589,
                            74.4055641448641, 65.7751317250688, 50.6780283433276, 75.5548591440746,
                            60.5709855281592, 64.1749504683645, 66.668026981514, 78.1565969968747,
                            49.4769141477712, 57.4527425748052, 66.0145861091829, 53.7271987704509,
                            67.4599505754041, 27.4386597690967, 16.5191057026163, 27.9496215841815,
                            23.9730914979175, 21.5069784244525, 25.5956263229809, 24.071745207076,
                            24.0340487258294, 27.8368610086022, 27.0313791223911, 21.3608163234604,
                            19.6424588818649, 23.7998797052906, 27.8132913666895, 26.8469677476742,
                            19.3195594264092, 18.5083369202647, 26.2708042872481, 21.0593582860758,
                            21.6903230800287, 23.5601695897029, 23.7631126751929, 24.7954405645187,
                            26.089740396713, 19.9046820116032, 21.4363147204981, 25.1376392737642,
                            21.7133418278442, 20.3830856896976, 26.5588472210756, 26.047482907622,
                            23.2654263407478, 26.2500554619614, 22.1180860462792, 23.4805945636441,
                            26.1261588483031, 25.4996410166251, 23.8310335718184, 26.4644074605471,
                            24.6337633324892, 26.669444393487, 18.2865711313409, 20.6197732441125,
                            27.5529123320628, 27.8749553881739, 25.484416426684, 23.8388188526714,
                            22.0164037680539, 26.7214167293085, 25.963394971704, 22.2749104460635,
                            22.3055116489428, 28.0372725526757, 28.2094824173975, 21.6551637172699,
                            24.6197964511732, 25.0946260082923, 21.3521526186868, 24.9382294588377,
                            23.4633217564073, 25.9619845657965, 27.275230924503, 28.1178917855965,
                            26.3395996631699, 26.5179746994942, 26.4562893535018, 23.6757859405614,
                            26.0599802578119, 27.1286862874745, 23.2331442579466, 22.1413971804387,
                            21.7884831023537, 25.5078566341171, 22.3430427088187, 28.1935325146442,
                            27.1065222414039, 23.9879361663935, 14.9257383945917, 24.21951409719,
                            22.0102354862931, 21.7090400653363, 27.3685363273551, 25.2003971749359,
                            25.1633277517419, 19.0521630979451, 26.8889405698337, 27.8349529397291,
                            21.7727972966867, 25.147157454298, 25.6079910074641, 21.4884526376261,
                            22.4569005478273, 24.3891012972191, 23.5776428291445, 23.8234274170797,
                            26.2362490023563, 27.3968772939196, 24.315277880481, 23.0244824053688,
                            24.4926411206519), .Dim = c(100L, 3L), .Dimnames = list(NULL,
                                                                                    c("SSE", "Chisq", "freemanTukey")))
                )

}

test.parboot.distsamp <- function() {

  data(issj)
  jayumf <- unmarkedFrameDS(y=as.matrix(issj[,1:3]),
  siteCovs=data.frame(scale(issj[,c("elevation","forest","chaparral")])),
  dist.breaks=c(0,100,200,300), unitsIn="m", survey="point")

  hn <- distsamp(~1 ~1, jayumf)
  neg <- distsamp(~1 ~1, jayumf,keyfun="exp")

  fitstats <- function(fm) {
    observed <- getY(fm@data)
    expected <- fitted(fm)
    resids <- residuals(fm)
    sse <- sum(resids^2)
    chisq <- sum((observed - expected)^2 / expected)
    out <- c(SSE=sse, Chisq=chisq)
    return(out)
  }

  set.seed(123)
  pb_hn <- parboot(hn, fitstats, nsim=2)
  checkEqualsNumeric(pb_hn@t0, c(435.8911, 2580.4320), tol=1e-4)
  checkEqualsNumeric(pb_hn@t.star, matrix(c(162.7815,156.1777,
                                            878.5063,931.6237),nrow=2),
                     tol=1e-4)

  pb_neg <- parboot(neg, fitstats, nsim=2)
  checkEqualsNumeric(pb_neg@t0, c(458.8042, 6007.6463), tol=1e-4)
  checkEqualsNumeric(pb_neg@t.star, matrix(c(164.8892,144.9085,
                                            938.8101,880.0353),nrow=2),
                     tol=1e-4)
}
