% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vuong.R
\name{vuong.test}
\alias{vuong.test}
\title{Vuong test}
\usage{
vuong.test(object1, object2, alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{object1, object2}{objects of class \code{\link[unitquantreg]{unitquantreg}}
containing the fitted models.}

\item{alternative}{indicates the alternative hypothesis and must be one
of \code{"two.sided"} (default), \code{"less"}, or \code{"greater"}. You can
specify just the initial letter of the value, but the argument name must be
given in full. See ‘Details’ for the meanings of the possible values.}
}
\value{
A list with class \code{"htest"} containing the following
components:
\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value of the test.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{a character string with the method used.}
\item{data.name}{a character string ginven the name of families models under comparison.}
}
\description{
Performs Vuong test between two fitted objects of class
\code{\link[unitquantreg]{unitquantreg}}
}
\details{
The statistic of Vuong likelihood ratio test for compare two
non-nested regression models is defined by
\deqn{T = \frac{1}{\widehat{\omega}^2\,\sqrt{n}}\,\sum_{i=1}^{n}\,
\log\frac{f(y_i \mid \bm{x}_i, \widehat{\bm{\theta}})}{
g(y_i \mid \bm{x}_i,\widehat{\bm{\gamma}})}}
where
\deqn{\widehat{\omega}^2 = \frac{1}{n}\,\sum_{i=1}^{n}\,\left(\log \frac{f(y_i \mid \bm{x}_i, \widehat{\bm{\theta}})}{g(y_i \mid \bm{x}_i, \widehat{\bm{\gamma}})}\right)^2 - \left[\frac{1}{n}\,\sum_{i=1}^{n}\,\left(\log \frac{f(y_i \mid \bm{x}_i, \widehat{\bm{\theta}})}{ g(y_i \mid \bm{x}_i, \widehat{\bm{\gamma}})}\right)\right]^2}
is an estimator for the variance of
\eqn{\frac{1}{\sqrt{n}}\,\displaystyle\sum_{i=1}^{n}\,\log\frac{f(y_i \mid \bm{x}_i, \widehat{\bm{\theta}})}{g(y_i \mid \bm{x}_i, \widehat{\bm{\gamma}})}},
\eqn{f(y_i \mid \bm{x}_i, \widehat{\bm{\theta}})} and
\eqn{g(y_i \mid \bm{x}_i, \widehat{\bm{\gamma}})}
are the corresponding rival densities evaluated at the maximum likelihood estimates.

When \eqn{n \rightarrow \infty} we have that \eqn{T \rightarrow N(0, 1)} in distribution.
Therefore, at \eqn{\alpha\%} level of significance  the null hypothesis of
the equivalence of the competing models is rejected if \eqn{|T| > z_{\alpha/2}},
where \eqn{z_{\alpha/2}} is the \eqn{\alpha/2} quantile of standard normal distribution.

In practical terms, \eqn{f(y_i \mid \bm{x}_i, \widehat{\bm{\theta}})}
is better (worse) than \eqn{g(y_i \mid \bm{x}_i, \widehat{\bm{\gamma}})}
if \eqn{T>z_{\alpha/2}} (or \eqn{T< -z_{\alpha/2}}).
}
\examples{
data(water, package = "unitquantreg")

fit_uweibull <- unitquantreg(formula = phpws ~ mhdi + incpc + region + log(pop),
tau = 0.5, data = water, family = "uweibull")
fit_kum <- unitquantreg(formula = phpws ~ mhdi, tau = 0.5, data = water,
family = "kum")

ans <- vuong.test(object1 = fit_uweibull, object2 = fit_kum)
ans
str(ans)


}
\references{
Vuong, Q. (1989). Likelihood ratio tests for model selection and
non-nested hypotheses. \emph{Econometrica}, \bold{57}(2), 307--333.
}
\author{
André F. B. Menezes \email{andrefelipemaringa@gmail.com}

Josmar Mazucheli \email{jmazucheli@gmail.com}
}
