% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{uni_freiburg_grey}
\alias{uni_freiburg_grey}
\title{Grey colors of the University of Freiburg.}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on web style guide at 
\url{https://uni-freiburg.de/} 
(at \code{portal.uni-freiburg.de/cmsforum/wsg/webstyleguide/farben} on 2022-10-20).
}
\usage{
uni_freiburg_grey
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_freiburg_grey} provides the grey colors 
of the \href{https://uni-freiburg.de/}{University of Freiburg}, Germany.
}
\examples{
uni_freiburg_grey
seecol(uni_freiburg_grey)  # view color palette
demopal(uni_freiburg_grey, type = 1, main = "Grey colors of the University of Freiburg")

}
\seealso{
\code{\link{uni_freiburg_br}} for the default colors of the University of Freiburg;  
\code{\link{uni_freiburg_info}} for the info colors of the University of Freiburg;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{eth_pal_grey}},
\code{\link{eth_pal_light}},
\code{\link{eth_pal}},
\code{\link{mpg_pal}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_konstanz_pref}},
\code{\link{uni_konstanz}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}}
}
\author{
Hansjoerg Neth, 2022-10-20.
}
\concept{contributed color palettes}
\keyword{datasets}
