% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphere.R
\name{runif_on_sphericalCap}
\alias{runif_on_sphericalCap}
\title{Uniform sampling on a spherical cap}
\usage{
runif_on_sphericalCap(n, r = 1, h)
}
\arguments{
\item{n}{number of simulations}

\item{r}{radius of the sphere}

\item{h}{height of the cap}
}
\value{
The simulations in a \code{n} times \code{3} matrix.
}
\description{
Uniform sampling on a spherical cap (in dimension 3).
}
\examples{
sims <- runif_on_sphericalCap(500, r = 2, h = 1)
\dontrun{
library(rgl)
spheres3d(0, 0, 0, radius = 2, color = "red", alpha = 0.5)
points3d(sims)}
}
