% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UMass.R
\docType{data}
\name{umass_2}
\alias{umass_2}
\title{Secondary colors of the University of Massachusetts Amherst, USA}
\format{
An object of class \code{character} of length 12.
}
\source{
Color definitions are based on the UMass 
\href{https://www.umass.edu/brand/elements/color}{Brand guide}.
}
\usage{
umass_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{umass_2} provides the twelve secondary colors to complement the signature brand colors
of the \href{https://www.umass.edu}{University of Massachusetts Amherst}, USA.
}
\details{
The 23 secondary colors are 
\code{"PMS 123"} (defined as C0 M19 Y89 K0, R255 G199 B44, HEX ffc72c),
\code{"PMS 1375"} (defined as C0 M45 Y94 K0, R255 G158 B27, HEX ff9e1b),
\code{"PMS 7669"} (defined as C73 M66 Y0 K2, R97 G94 B155, HEX 615e9b),
\code{"PMS 7743"} (defined as C71 M8 Y100 K50, R68 G105 B61, HEX 44693d),
\code{"PMS 7519"} (defined as C24 M42 Y45 K68, R94 G75 B60, HEX 5e4b3c),
\code{"PMS 655"} (defined as C100 M79 Y12 K59, R0 G37 B84, HEX 002554),
\code{"PMS 3125"} (defined as C84 M0 Y18 K0, R0 G174 B199, HEX 00aec7),
\code{"PMS 564"} (defined as C43 M0 Y23 K0, R134 G200 B188, HEX 86c8bc),
\code{"PMS 7737"} (defined as C60 M0 Y98 K7, R107 G165 B57, HEX 6ba539),
\code{"PMS 382"} (defined as C28 M0 Y100 K0, R196 G214 B0, HEX c4d600),
\code{"PMS 159"} (defined as C1 M72 Y100 K7, R203 G96 B21, HEX cb6015), and
\code{"PMS bright red"} (defined as C0 M90 Y95 K0, R254 G59 B31, HEX fe3b1f).

Note that secondary colors must never overpower the brand colors.

\code{umass_2} uses the HEX color definitions.
}
\examples{
umass_2
unikn::seecol(umass_2, main = "Secondary colors of UMass") # view color palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-27.
}
\concept{U.S. university color palettes}
\keyword{datasets}
