% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu.R
\name{xmu_get_CI}
\alias{xmu_get_CI}
\title{Look up and report CIs for free parameters}
\usage{
xmu_get_CI(
  model,
  label,
  prefix = "top.",
  suffix = "_std",
  digits = 2,
  SEstyle = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{model}{an \code{\link[=mxModel]{mxModel()}} to get CIs from}

\item{label}{the label of the cell to interrogate for a CI, e.g. "ai_r1c1"}

\item{prefix}{The submodel to look in (default = "top.")}

\item{suffix}{The suffix for algebras when standardized (default = "_std")}

\item{digits}{Rounding digits.}

\item{SEstyle}{If TRUE, report "b(se)" instead of b CI95[l,u] (default = FALSE)}

\item{verbose}{= FALSE}
}
\value{
\itemize{
\item the CI string, e.g. ".73[-.20, .98]" or .73(.10)
}
}
\description{
Look up CIs for free parameters in a model, and return as APA-formatted text string.
If std are available, then these are reported.
}
\examples{
\dontrun{
require(umx); data(demoOneFactor)
manifests = names(demoOneFactor)

tmp = umxRAM("get_CI_example", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)
tmp = umxCI(tmp, run= "yes")

# Get CI by parameter label
xmu_get_CI(model= tmp, "x1_with_x1")
xmu_get_CI(model= tmp, "x1_with_x1", SEstyle = TRUE, digits = 3)

# prefix (submodel) and suffix (e.g. std) are ignored if not needed
xmu_get_CI(model= tmp, "x1_with_x1", prefix = "top.", suffix = "_std")

xmu_get_CI(fit_IP, label = "ai_r1c1", prefix = "top.", suffix = "_std")
xmu_get_CI(fit_IP, label = "ai_r1c1", prefix = "top.", SEstyle = TRUE, suffix = "_std")
}

}
\references{
\itemize{
\item \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
}
\seealso{
Other xmu internal not for end user: 
\code{\link{umxModel}()},
\code{\link{umxRenameMatrix}()},
\code{\link{umx_APA_pval}()},
\code{\link{umx_fun_mean_sd}()},
\code{\link{umx_get_bracket_addresses}()},
\code{\link{umx_make}()},
\code{\link{umx_standardize}()},
\code{\link{umx_string_to_algebra}()},
\code{\link{umx}},
\code{\link{xmuHasSquareBrackets}()},
\code{\link{xmuLabel_MATRIX_Model}()},
\code{\link{xmuLabel_Matrix}()},
\code{\link{xmuLabel_RAM_Model}()},
\code{\link{xmuMI}()},
\code{\link{xmuMakeDeviationThresholdsMatrices}()},
\code{\link{xmuMakeOneHeadedPathsFromPathList}()},
\code{\link{xmuMakeTwoHeadedPathsFromPathList}()},
\code{\link{xmuMaxLevels}()},
\code{\link{xmuMinLevels}()},
\code{\link{xmuPropagateLabels}()},
\code{\link{xmuRAM2Ordinal}()},
\code{\link{xmuTwinSuper_Continuous}()},
\code{\link{xmuTwinUpgradeMeansToCovariateModel}()},
\code{\link{xmu_CI_merge}()},
\code{\link{xmu_CI_stash}()},
\code{\link{xmu_DF_to_mxData_TypeCov}()},
\code{\link{xmu_PadAndPruneForDefVars}()},
\code{\link{xmu_bracket_address2rclabel}()},
\code{\link{xmu_cell_is_on}()},
\code{\link{xmu_check_levels_identical}()},
\code{\link{xmu_check_needs_means}()},
\code{\link{xmu_check_variance}()},
\code{\link{xmu_clean_label}()},
\code{\link{xmu_data_missing}()},
\code{\link{xmu_data_swap_a_block}()},
\code{\link{xmu_describe_data_WLS}()},
\code{\link{xmu_dot_make_paths}()},
\code{\link{xmu_dot_make_residuals}()},
\code{\link{xmu_dot_maker}()},
\code{\link{xmu_dot_move_ranks}()},
\code{\link{xmu_dot_rank_str}()},
\code{\link{xmu_extract_column}()},
\code{\link{xmu_lavaan_process_group}()},
\code{\link{xmu_make_TwinSuperModel}()},
\code{\link{xmu_make_bin_cont_pair_data}()},
\code{\link{xmu_make_mxData}()},
\code{\link{xmu_match.arg}()},
\code{\link{xmu_name_from_lavaan_str}()},
\code{\link{xmu_path2twin}()},
\code{\link{xmu_path_regex}()},
\code{\link{xmu_rclabel_2_bracket_address}()},
\code{\link{xmu_safe_run_summary}()},
\code{\link{xmu_set_sep_from_suffix}()},
\code{\link{xmu_show_fit_or_comparison}()},
\code{\link{xmu_simplex_corner}()},
\code{\link{xmu_standardize_ACEcov}()},
\code{\link{xmu_standardize_ACEv}()},
\code{\link{xmu_standardize_ACE}()},
\code{\link{xmu_standardize_CP}()},
\code{\link{xmu_standardize_IP}()},
\code{\link{xmu_standardize_RAM}()},
\code{\link{xmu_standardize_SexLim}()},
\code{\link{xmu_standardize_Simplex}()},
\code{\link{xmu_start_value_list}()},
\code{\link{xmu_starts}()},
\code{\link{xmu_twin_add_WeightMatrices}()},
\code{\link{xmu_twin_check}()},
\code{\link{xmu_twin_get_var_names}()},
\code{\link{xmu_twin_upgrade_selDvs2SelVars}()}
}
\concept{xmu internal not for end user}
