% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{docData}
\alias{docData}
\title{Twin data for Direction of causation modelling}
\format{
A data frame 6 manifests for each of two twins in 1400 families of MZ and DZ twins
}
\usage{
data(docData)
}
\description{
A dataset containing indicators for two traits \code{varA} and \code{varB}, each measured in MZ and DZ twins.
}
\details{
It is designed to show off \code{\link[=umxDoC]{umxDoC()}} testing the hypothesis \code{varA} causes \code{varB}, \code{varB} causes \code{varA}, both cause each other.
\itemize{
\item \emph{zygosity} "MZFF", "DZFF", "MZMM", or "DZMM"
\item \emph{varA1_T1} Twin one's manifest 1 for varA
\item \emph{varA2_T1} Twin one's manifest 2 for varA
\item \emph{varA3_T1} Twin one's manifest 3 for varA
\item \emph{varB1_T1} Twin one's manifest 1 for varB
\item \emph{varB2_T1} Twin one's manifest 2 for varB
\item \emph{varB3_T1} Twin one's manifest 3 for varB
\item \emph{varA1_T2} Twin two's manifest 1 for varA
\item \emph{varA2_T2} Twin two's manifest 2 for varA
\item \emph{varA3_T2} Twin two's manifest 3 for varA
\item \emph{varB1_T2} Twin two's manifest 1 for varB
\item \emph{varB2_T2} Twin two's manifest 2 for varB
\item \emph{varB3_T2} Twin two's manifest 3 for varB
}
}
\examples{
data(docData)
str(docData)
mzData = subset(docData, zygosity \%in\% c("MZFF", "MZMM"))
dzData = subset(docData, zygosity \%in\% c("DZFF", "DZMM"))
par(mfrow = c(1, 2))  # 1 rows and 3 columns
plot(varA1_T2 ~varA1_T1, ylim = c(-4, 4), data = mzData, main="MZ")
tmp = round(cor.test(~varA1_T1 + varA1_T2, data = mzData)$estimate, 2)
text(x=-4, y=3, labels = paste0("r = ", tmp))
plot(varA1_T2 ~varA1_T1, ylim = c(-4, 4), data = dzData, main="DZ")
tmp = round(cor.test(~varA1_T1 + varA1_T2, data = dzData)$estimate, 2)
text(x=-4, y=3, labels = paste0("r = ", tmp))
par(mfrow = c(1, 1))  # back to as it was
}
\references{
\itemize{
\item N.A. Gillespie and N.G. Martin (2005). Direction of Causation Models.
In \emph{Encyclopedia of Statistics in Behavioral Science}, \strong{1}, 496–499. Eds. Brian S. Everitt & David C. Howell
}
}
\seealso{
\itemize{
\item \code{\link[=umxDoC]{umxDoC()}}, \code{\link[=plot.MxModelDoC]{plot.MxModelDoC()}}, \code{\link[=umxSummary.MxModelDoC]{umxSummary.MxModelDoC()}}, \code{\link[=umxModify]{umxModify()}}
}

Other datasets: 
\code{\link{Fischbein_wt}},
\code{\link{GFF}},
\code{\link{iqdat}},
\code{\link{umx}},
\code{\link{us_skinfold_data}}
}
\concept{datasets}
\keyword{datasets}
